(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29582,        552]
NotebookOptionsPosition[     29098,        533]
NotebookOutlinePosition[     29517,        549]
CellTagsIndexPosition[     29474,        546]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook plots the sample function for the problems at the end of \
Chapter 8.

See Chapter 8 : Data Fitting for details.

Updated July 2008
\
\>", "Input",
 CellChangeTimes->{{3.4260187738282557`*^9, 3.4260188400434685`*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"ToFileName", "[", 
     RowBox[{"Extract", "[", 
      RowBox[{
       RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
        RowBox[{"NotebookInformation", "[", 
         RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
       RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
    "]"}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x_", "]"}], ":=", 
    RowBox[{
     FractionBox["x", "10"], "+", 
     RowBox[{
      FractionBox["1", "7"], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "3"]}], "]"}]}], "+", 
     FractionBox[
      SuperscriptBox["x", "3"], "4"]}]}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pic", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Thickness", "[", "0.01`", "]"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Thickness", "[", "0.01`", "]"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
     RowBox[{"ColorOutput", "\[Rule]", "GrayLevel"}]}], "]"}]}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<samplefct.eps\>\"", ",", "pic"}], "]"}]}], "Input",
 CellChangeTimes->{{3.426018843868969*^9, 3.4260188500879116`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.01], LineBox[CompressedData["
1:eJwUV3k8VO8XRiJkSUhSJESLCikVR7KUosiWhFSSSkQq2ZKkkqhICtlaZAul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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  ColorOutput->GrayLevel,
  PlotRange->{{-2, 2}, {-2.1966230006552143`, 2.2605963678021794`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4260188546845207`*^9}],

Cell[BoxData["\<\"samplefct.eps\"\>"], "Output",
 CellChangeTimes->{3.4260188549048376`*^9}]
}, Open  ]]
},
WindowSize->{808, 835},
WindowMargins->{{35, Automatic}, {Automatic, 22}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 412, 14, 223, "Input"],
Cell[CellGroupData[{
Cell[1005, 39, 1771, 50, 332, "Input"],
Cell[2779, 91, 26208, 436, 310, "Output"],
Cell[28990, 529, 92, 1, 48, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
