(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52439,       1179]
NotebookOptionsPosition[     50505,       1120]
NotebookOutlinePosition[     50944,       1137]
CellTagsIndexPosition[     50901,       1134]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates scatter  plots, correlations, line of regression, \
and dominant lines. These tools help us see trends in the data.

Input: two data sets. Here we have 8 weight and height pairs of data.
Output: mean, standard deviation, correlation coefficient, \"time series\" \
plots, scatter plot, the line of regression and the dominant line over the \
scatter plot. 

The dominant line is computed by revisiting PCA from Chapter 6.

Figures  12.1, 12.2, and 12.5 were created with this notebook.

See Chapter 12: Visualization of Empirical Data for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.4265262915062256`*^9, 3.4265262920369887`*^9}, {
  3.4265300094723983`*^9, 3.4265300225111475`*^9}, {3.4265362751119456`*^9, 
  3.4265364929652033`*^9}, {3.4265365264633713`*^9, 3.426536526603573*^9}, {
  3.426536560582432*^9, 3.4265366921215763`*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Load", " ", "packages", " ", "needed"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Set", " ", "output", " ", "folder"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "data", " ", "sets"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"weights", "=", 
     RowBox[{"{", 
      RowBox[{
      "65", ",", "60", ",", "50", ",", "52", ",", "75", ",", "52", ",", "72", 
       ",", "63"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"heights", "=", 
     RowBox[{"{", 
      RowBox[{
      "172", ",", "170", ",", "150", ",", "156", ",", "172", ",", "160", ",", 
       "161", ",", "160"}], "}"}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Find", " ", "mean", " ", "of", " ", "each", " ", "data", " ", "set"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"meanwt", "=", 
     RowBox[{"N", "[", 
      RowBox[{"Mean", "[", "weights", "]"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"meanht", "=", 
     RowBox[{"N", "[", 
      RowBox[{"Mean", "[", "heights", "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Find", " ", "standard", " ", "deviation", " ", "of", " ", "data", " ", 
     "sets"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stdwts", "=", 
     RowBox[{"N", "[", 
      RowBox[{"StandardDeviation", "[", "weights", "]"}], "]"}]}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{"stdhts", "=", 
     RowBox[{"N", "[", 
      RowBox[{"StandardDeviation", "[", "heights", "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Center", " ", "each", " ", "data", " ", "set", " ", "about", " ", "the", 
     " ", "mean"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"mweights", "=", 
     RowBox[{"weights", "-", "meanwt"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"mheights", "=", 
     RowBox[{"heights", "-", "meanht"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", "\"\<Weights translated so mean is at the origin\>\"", "]"}],
    "\n", 
   RowBox[{"Print", "[", "mweights", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\< \>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", "\"\<Height translated so mean is at the origin\>\"", "]"}], 
   "\n", 
   RowBox[{"Print", "[", "mheights", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\< \>\"", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Get", " ", "the", " ", "standard", " ", "deviation", " ", "of", " ", 
     "the", " ", "modified", " ", "data", " ", "sets"}], " ", "*)"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"And", " ", "print", " ", "it", " ", "out"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Standard deviation of mweights = \>\"", ",", 
     RowBox[{"N", "[", 
      RowBox[{"StandardDeviation", "[", "mweights", "]"}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Standard deviation of mheights = \>\"", ",", 
     RowBox[{"N", "[", 
      RowBox[{"StandardDeviation", "[", "mheights", "]"}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\< \>\"", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Comput", " ", "the", " ", "correlation", " ", "coefficient", " ", 
     "between", " ", "the", " ", "data", " ", "sets"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Correllation coefficient for two data sets = \>\"", ",", 
     RowBox[{"Correlation", "[", 
      RowBox[{"mweights", ",", "mheights"}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\< \>\"", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "FInd", " ", "the", " ", "slope", " ", "of", " ", "the", " ", "line", " ",
      "of", " ", "regression"}], " ", "*)"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"See", " ", "equation", " ", 
     RowBox[{"(", "12.4", ")"}], " ", "for", " ", "details"}], " ", "*)"}], 
   " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slope", "=", 
     FractionBox[
      RowBox[{"mweights", ".", "mheights"}], 
      RowBox[{"mweights", ".", "mweights"}]]}], ";"}], "\[IndentingNewLine]", 
   "\n", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Line of regression: slope= \>\"", ",", "slope"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\< \>\"", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Set", " ", "up", " ", "for", " ", "drawing", " ", "the", " ", "line", 
     " ", "of", " ", "regression"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"linelst", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "15"}], ",", 
         RowBox[{
          RowBox[{"-", "15"}], " ", "slope"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", 
         RowBox[{"15", " ", "slope"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "weights", 
     " ", "data", " ", "set", " ", "which", " ", "has", " ", "been", " ", 
     "translated", " ", "so", " ", "the", " ", "it", " ", "is", " ", 
     "centered", " ", "about", " ", "its", " ", "mean"}], " ", "*)"}], "\n", 
   RowBox[{"Print", "[", "\"\<Plot of mweights \>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"picwts", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{"mweights", ",", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"PointSize", "[", "0.03`", "]"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "15"}], ",", "15"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}], 
   "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "heights", 
     " ", "data", " ", 
     RowBox[{"set", " ", "--"}], " ", "also", " ", "modified", " ", "to", " ",
      "be", " ", "centered", " ", "about", " ", "its", " ", "mean"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<plot of mheights \>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"pichts", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{"mheights", ",", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"PointSize", "[", "0.03`", "]"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "15"}], ",", "15"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "table", " ", "bringing", " ", "together", " ", 
     "the", " ", "weight", " ", "and", " ", "height", " ", "data", " ", 
     "sets"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "will", " ", "be", " ", "used", " ", "for", " ", "a", " ", 
     "scatter", " ", "plot"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"joindata", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "mweights", "\[LeftDoubleBracket]", "k", "\[RightDoubleBracket]"}], 
         ",", 
         RowBox[{
         "mheights", "\[LeftDoubleBracket]", "k", "\[RightDoubleBracket]"}]}],
         "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "1", ",", 
         RowBox[{"Length", "[", "mweights", "]"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Weight and height data in one table as {weight,height} pairs: \>\"", 
     ",", "joindata"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\< \>\"", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "scatter", " ", "plot", " ", "with", " ", "the", 
     " ", "line", " ", "of", " ", "regression"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<Scatter plot -- coordinates (weight,height) and add the line of \
regression\>\"", "]"}], "\n", 
   RowBox[{"picscatter", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"joindata", ",", " ", "linelst"}], "}"}], ",", 
      RowBox[{"Joined", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"False", ",", " ", "True"}], "}"}]}], ",", 
      RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"PointSize", "[", "0.03", "]"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Thickness", "[", "0.015", "]"}], "}"}]}], "}"}]}], ",", 
      " ", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "15"}], ",", "15"}], "}"}]}], "}"}]}]}], "]"}]}], 
   "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Output", " ", "plots", " ", "to", " ", "postscript", " ", "files"}], " ",
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<timeseries_wts.eps\>\"", ",", "picwts"}], "]"}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<timeseries_hts.eps\>\"", ",", "pichts"}], "]"}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<scatterplot_wtshts.eps\>\"", ",", "picscatter"}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Principal", " ", "Components", " ", 
     RowBox[{"Analysis", " ", "--"}], " ", "PCA"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Copy", " ", "the", " ", "weight", " ", "and", " ", "height", " ", 
     "data"}], " ", "*)"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"We", " ", "have", " ", "a", " ", 
      RowBox[{"table", "/", "matrix"}], " ", "of", " ", 
      RowBox[{"(", 
       RowBox[{"weight1", ",", "height1"}], ")"}]}], ",", " ", 
     RowBox[{"(", 
      RowBox[{"weight2", ",", " ", "height2"}], ")"}], ",", 
     RowBox[{"...", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Having", " ", "n", " ", "rows", " ", "and", " ", "2", " ", "columns"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"rmat", "=", 
    TagBox["joindata",
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "transpose", " ", "matrix", " ", "having", " ", 
     "2", " ", "rows", " ", "and", " ", "n", " ", "columns"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"rtmat", "=", 
    TagBox[
     RowBox[{"Transpose", "[", "joindata", "]"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Multiply", " ", "the", " ", "transpose", " ", "matrix", " ", "times", 
     " ", "the", " ", "matrix"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"smat", "=", 
     RowBox[{
      RowBox[{"Transpose", "[", "joindata", "]"}], ".", "joindata"}]}], ";"}],
    "\n", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<matrix from jointdata^T * joindata   smat = \>\"", ",", "smat"}], 
    "]"}], "\n", 
   RowBox[{"Print", "[", "\"\< \>\"", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Find", " ", "the", " ", "eigenvalues", " ", "of", " ", "the", " ", 
     "product", " ", "matrix"}], " ", "*)"}], "\n", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Eigenvalues of smat = \>\"", ",", 
     RowBox[{"Eigenvalues", "[", "smat", "]"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\< \>\"", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Find", " ", "the", " ", "eigenvectors", " ", "of", " ", "the", " ", 
     "product", " ", "matrix"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "The", " ", "eigenvector", " ", "corresponding", " ", "to", " ", "the", 
     " ", "largest", " ", "eigenvalue", " ", "is", " ", "the", " ", 
     "dominant", " ", "line", " ", "of", " ", "the", " ", "data", " ", 
     "set"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e1", ",", "e2"}], "}"}], "=", 
     RowBox[{"Eigenvectors", "[", "smat", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Eigenvectors of smat:  e1=\>\"", ",", "e1", ",", "\"\<  e2=\>\"", 
     ",", "e2"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\< \>\"", "]"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Slope", " ", "of", " ", "the", " ", "dominant", " ", "line", " ", "is", 
     " ", "the", " ", "quotient", " ", "of", " ", "the", " ", "components", 
     " ", "of", " ", "the", " ", "dominant", " ", 
     RowBox[{"eigenvector", ".", " ", "Recall"}], " ", "slope", " ", "is", 
     " ", 
     RowBox[{"rise", "/", "run"}]}], "  ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"domslope", "=", 
     FractionBox[
      RowBox[{"e1", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
      RowBox[{"e1", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Slope of dominant line = \>\"", ",", "domslope"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\< \>\"", "]"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "data", " ", "to", " ", "plot", " ", "the", " ", 
     "dominant", " ", "line"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"domline", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "15"}], ",", 
         RowBox[{
          RowBox[{"-", "15"}], " ", "domslope"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", 
         RowBox[{"15", " ", "domslope"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", 
      RowBox[{"weight", "/", "height"}], " ", "data"}], ",", " ", 
     RowBox[{"the", " ", "dominant", " ", "line"}], ",", " ", 
     RowBox[{"and", " ", "the", " ", "line", " ", "of", " ", "regression"}]}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<Plot of (weight,height) data, the dominant line, the line of \
regression\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<Dominant line is brown. Line of regression is purple.\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"picdominant", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"joindata", ",", "linelst", ",", "domline"}], "}"}], ",", 
      RowBox[{"Joined", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True", ",", "True"}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Blue", ",", 
           RowBox[{"PointSize", "[", "0.03", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Purple", ",", 
           RowBox[{"Thickness", "[", "0.01`", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Brown", ",", 
           RowBox[{"Thickness", "[", "0.01`", "]"}]}], "}"}]}], "}"}]}], ",", 
      
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "15"}], ",", "15"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\n", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{
    "Output", " ", "this", " ", "plot", " ", "to", " ", "a", " ", 
     "postscript", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<scatterplot_dom.eps\>\"", ",", "picdominant"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4265300992815375`*^9, 3.4265302620355663`*^9}, 
   3.4265303193680067`*^9, {3.426530414214389*^9, 3.4265304412432547`*^9}, {
   3.426530480900278*^9, 3.4265308498307743`*^9}, {3.4265308914506207`*^9, 
   3.426531154889427*^9}, {3.4265311872459536`*^9, 3.4265312304781184`*^9}, {
   3.426531282723243*^9, 3.426531455722003*^9}, {3.426531547303691*^9, 
   3.4265316774207907`*^9}, {3.4265317121006575`*^9, 3.42653171522515*^9}, {
   3.426533244914736*^9, 3.4265333116607122`*^9}, {3.4265333447382755`*^9, 
   3.42653335717616*^9}, {3.4265334295402145`*^9, 3.4265334443014402`*^9}, {
   3.4265334761572466`*^9, 3.4265335096353855`*^9}, {3.4265335403295217`*^9, 
   3.426533805751179*^9}, {3.426533861821805*^9, 3.426533874890597*^9}, {
   3.426533914918154*^9, 3.4265340178361425`*^9}, {3.42653407411707*^9, 
   3.426534152419664*^9}, {3.426534257320504*^9, 3.4265342725724354`*^9}, {
   3.4265345006904526`*^9, 3.4265345048965006`*^9}, {3.426534623326795*^9, 
   3.4265346502755456`*^9}, {3.4265347081287346`*^9, 3.426534711603731*^9}, {
   3.426534752632728*^9, 3.426534795294072*^9}, {3.4265348406793327`*^9, 
   3.4265348441042576`*^9}, {3.426534874848466*^9, 3.426534932411237*^9}, {
   3.426535050791459*^9, 3.4265351396792736`*^9}, {3.4265352290978513`*^9, 
   3.4265353081715536`*^9}, {3.4265353874355297`*^9, 
   3.4265354066030912`*^9}, {3.4265354424846864`*^9, 3.4265354649169426`*^9}, 
   3.4265354985753407`*^9, 3.426535612739501*^9, 3.426536002509963*^9, {
   3.4265360585505457`*^9, 3.4265360624561615`*^9}, {3.426536099259082*^9, 
   3.426536183640416*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Weights translated so mean is at the origin\"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.4265361848822017`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.875`", ",", 
   RowBox[{"-", "1.125`"}], ",", 
   RowBox[{"-", "11.125`"}], ",", 
   RowBox[{"-", "9.125`"}], ",", "13.875`", ",", 
   RowBox[{"-", "9.125`"}], ",", "10.875`", ",", "1.875`"}], "}"}]], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.4265361849022303`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.426536184932274*^9}],

Cell[BoxData["\<\"Height translated so mean is at the origin\"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.426536184942288*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9.375`", ",", "7.375`", ",", 
   RowBox[{"-", "12.625`"}], ",", 
   RowBox[{"-", "6.625`"}], ",", "9.375`", ",", 
   RowBox[{"-", "2.625`"}], ",", 
   RowBox[{"-", "1.625`"}], ",", 
   RowBox[{"-", "2.625`"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.4265361849523025`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.4265361849523025`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Standard deviation of mweights = \"\>", "\[InvisibleSpace]", 
   "9.417878135303544`"}],
  SequenceForm["Standard deviation of mweights = ", 9.417878135303544],
  Editable->False]], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.4265361849623165`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Standard deviation of mheights = \"\>", "\[InvisibleSpace]", 
   "8.016723591521485`"}],
  SequenceForm["Standard deviation of mheights = ", 8.016723591521485],
  Editable->False]], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.426536184972331*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.4265361849823456`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Correllation coefficient for two data sets = \"\>", 
   "\[InvisibleSpace]", "0.6818779378238629`"}],
  SequenceForm[
  "Correllation coefficient for two data sets = ", 0.6818779378238629],
  Editable->False]], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.42653618499236*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.42653618499236*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Line of regression: slope= \"\>", "\[InvisibleSpace]", 
   "0.5804308435675458`"}],
  SequenceForm["Line of regression: slope= ", 0.5804308435675458],
  Editable->False]], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.4265361850023746`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.4265361850123887`*^9}],

Cell[BoxData["\<\"Plot of mweights \"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.4265361850123887`*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointSize[0.03], 
    PointBox[{{1., 3.875}, {2., -1.125}, {3., -11.125}, {4., -9.125}, {5., 
     13.875}, {6., -9.125}, {7., 10.875}, {8., 1.875}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  PlotRange->{{0, 9}, {-15, 15}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.426531692802909*^9, 3.4265317214541073`*^9}, 
   3.4265333149955072`*^9, 3.4265334455832834`*^9, 3.42653351073697*^9, 
   3.426534157547037*^9, 3.4265345070195537`*^9, 3.4265346567849054`*^9, 
   3.4265347171917667`*^9, {3.4265347704483457`*^9, 3.4265347975072546`*^9}, {
   3.4265348867956448`*^9, 3.4265349043609023`*^9}, 3.4265351460183887`*^9, 
   3.426535310404765*^9, 3.426535362689947*^9, 3.426535470835453*^9, 
   3.4265355012191424`*^9, 3.4265356147724237`*^9, 3.4265361850324173`*^9}],

Cell[BoxData["\<\"plot of mheights \"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.4265361850724754`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointSize[0.03], 
    PointBox[{{1., 9.375}, {2., 7.375}, {3., -12.625}, {4., -6.625}, {5., 
     9.375}, {6., -2.625}, {7., -1.625}, {8., -2.625}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  PlotRange->{{0, 9}, {-15, 15}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.426531692802909*^9, 3.4265317214541073`*^9}, 
   3.4265333149955072`*^9, 3.4265334455832834`*^9, 3.42653351073697*^9, 
   3.426534157547037*^9, 3.4265345070195537`*^9, 3.4265346567849054`*^9, 
   3.4265347171917667`*^9, {3.4265347704483457`*^9, 3.4265347975072546`*^9}, {
   3.4265348867956448`*^9, 3.4265349043609023`*^9}, 3.4265351460183887`*^9, 
   3.426535310404765*^9, 3.426535362689947*^9, 3.426535470835453*^9, 
   3.4265355012191424`*^9, 3.4265356147724237`*^9, 3.426536185092504*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Weight and height data in one table as {weight,height} pairs: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.875`", ",", "9.375`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.125`"}], ",", "7.375`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11.125`"}], ",", 
       RowBox[{"-", "12.625`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9.125`"}], ",", 
       RowBox[{"-", "6.625`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13.875`", ",", "9.375`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9.125`"}], ",", 
       RowBox[{"-", "2.625`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10.875`", ",", 
       RowBox[{"-", "1.625`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.875`", ",", 
       RowBox[{"-", "2.625`"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Weight and height data in one table as {weight,height} pairs: ", {{3.875, 
   9.375}, {-1.125, 7.375}, {-11.125, -12.625}, {-9.125, -6.625}, {13.875, 
   9.375}, {-9.125, -2.625}, {10.875, -1.625}, {1.875, -2.625}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.4265361851125326`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.426536185122547*^9}],

Cell[BoxData["\<\"Scatter plot -- coordinates (weight,height) and add the \
line of regression\"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.426536185162605*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{3.875, 9.375}, {-1.125, 
   7.375}, {-11.125, -12.625}, {-9.125, -6.625}, {13.875, 
   9.375}, {-9.125, -2.625}, {10.875, -1.625}, {
   1.875, -2.625}, {-15., -8.706462653513187}, {15., 8.706462653513187}, {
   3.875, 9.375}, {-1.125, 7.375}, {-11.125, -12.625}, {-9.125, -6.625}, {
   13.875, 9.375}, {-9.125, -2.625}, {10.875, -1.625}, {
   1.875, -2.625}}, {{{}, {}, {}, 
     {Hue[0.9060679774997897, 0.6, 0.6], Thickness[0.015], 
      LineBox[{9, 10}]}}, {
     {Hue[0.67, 0.6, 0.6], PointSize[0.03], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 11], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 12], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 13], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 14], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 15], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 16], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 17], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 18]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], Thickness[0.015], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 9], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 10]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  PlotRange->{{-15, 15}, {-15, 15}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.426531692802909*^9, 3.4265317214541073`*^9}, 
   3.4265333149955072`*^9, 3.4265334455832834`*^9, 3.42653351073697*^9, 
   3.426534157547037*^9, 3.4265345070195537`*^9, 3.4265346567849054`*^9, 
   3.4265347171917667`*^9, {3.4265347704483457`*^9, 3.4265347975072546`*^9}, {
   3.4265348867956448`*^9, 3.4265349043609023`*^9}, 3.4265351460183887`*^9, 
   3.426535310404765*^9, 3.426535362689947*^9, 3.426535470835453*^9, 
   3.4265355012191424`*^9, 3.4265356147724237`*^9, 3.426536185192648*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.875`", ",", "9.375`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.125`"}], ",", "7.375`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "11.125`"}], ",", 
     RowBox[{"-", "12.625`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "9.125`"}], ",", 
     RowBox[{"-", "6.625`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13.875`", ",", "9.375`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "9.125`"}], ",", 
     RowBox[{"-", "2.625`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10.875`", ",", 
     RowBox[{"-", "1.625`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.875`", ",", 
     RowBox[{"-", "2.625`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.426531692802909*^9, 3.4265317214541073`*^9}, 
   3.4265333149955072`*^9, 3.4265334455832834`*^9, 3.42653351073697*^9, 
   3.426534157547037*^9, 3.4265345070195537`*^9, 3.4265346567849054`*^9, 
   3.4265347171917667`*^9, {3.4265347704483457`*^9, 3.4265347975072546`*^9}, {
   3.4265348867956448`*^9, 3.4265349043609023`*^9}, 3.4265351460183887`*^9, 
   3.426535310404765*^9, 3.426535362689947*^9, 3.426535470835453*^9, 
   3.4265355012191424`*^9, 3.4265356147724237`*^9, 3.4265361854630365`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.875`", ",", 
     RowBox[{"-", "1.125`"}], ",", 
     RowBox[{"-", "11.125`"}], ",", 
     RowBox[{"-", "9.125`"}], ",", "13.875`", ",", 
     RowBox[{"-", "9.125`"}], ",", "10.875`", ",", "1.875`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9.375`", ",", "7.375`", ",", 
     RowBox[{"-", "12.625`"}], ",", 
     RowBox[{"-", "6.625`"}], ",", "9.375`", ",", 
     RowBox[{"-", "2.625`"}], ",", 
     RowBox[{"-", "1.625`"}], ",", 
     RowBox[{"-", "2.625`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.426531692802909*^9, 3.4265317214541073`*^9}, 
   3.4265333149955072`*^9, 3.4265334455832834`*^9, 3.42653351073697*^9, 
   3.426534157547037*^9, 3.4265345070195537`*^9, 3.4265346567849054`*^9, 
   3.4265347171917667`*^9, {3.4265347704483457`*^9, 3.4265347975072546`*^9}, {
   3.4265348867956448`*^9, 3.4265349043609023`*^9}, 3.4265351460183887`*^9, 
   3.426535310404765*^9, 3.426535362689947*^9, 3.426535470835453*^9, 
   3.4265355012191424`*^9, 3.4265356147724237`*^9, 3.4265361854830656`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"matrix from jointdata^T * joindata   smat = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"620.875`", ",", "360.375`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"360.375`", ",", "449.875`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "matrix from jointdata^T * joindata   smat = ", {{620.875, 360.375}, {
   360.375, 449.875}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.42653618549308*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.42653618549308*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Eigenvalues of smat = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"905.7537124349886`", ",", "164.99628756501136`"}], "}"}]}],
  SequenceForm[
  "Eigenvalues of smat = ", {905.7537124349886, 164.99628756501136`}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.426536185543152*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.4265361855531664`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Eigenvectors of smat:  e1=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0.784488623419723`", ",", "0.6201432090453204`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"  e2=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6201432090453204`"}], ",", "0.7844886234197229`"}], 
    "}"}]}],
  SequenceForm[
  "Eigenvectors of smat:  e1=", {0.784488623419723, 0.6201432090453204}, 
   "  e2=", {-0.6201432090453204, 0.7844886234197229}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.4265361855531664`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.426536185563181*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Slope of dominant line = \"\>", "\[InvisibleSpace]", 
   "0.7905063126881404`"}],
  SequenceForm["Slope of dominant line = ", 0.7905063126881404],
  Editable->False]], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.4265361855731955`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.4265361855731955`*^9}],

Cell[BoxData["\<\"Plot of (weight,height) data, the dominant line, the line \
of regression\"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.4265361855832095`*^9}],

Cell[BoxData["\<\"Dominant line is brown. Line of regression is \
purple.\"\>"], "Print",
 CellChangeTimes->{{3.426531692602621*^9, 3.4265317213339343`*^9}, 
   3.42653331486532*^9, 3.4265334454330673`*^9, 3.426533510586754*^9, 
   3.426534157396821*^9, 3.4265345068693376`*^9, 3.4265346566246753`*^9, 
   3.4265347170415506`*^9, {3.426534770308144*^9, 3.4265347973570385`*^9}, {
   3.426534886655443*^9, 3.4265349042106867`*^9}, 3.426535145878187*^9, 
   3.426535310264563*^9, 3.4265353625197024`*^9, 3.426535470685237*^9, 
   3.426535501078941*^9, 3.426535614622208*^9, 3.426536185593224*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{{}, {}, {}, 
    {RGBColor[0.5, 0, 0.5], Thickness[0.01], 
     LineBox[{{-15., -8.706462653513187}, {15., 8.706462653513187}}]}, 
    {RGBColor[0.6, 0.4, 0.2], Thickness[0.01], 
     LineBox[{{-15., -11.857594690322106`}, {15., 
      11.857594690322106`}}]}}, {{}, 
    {RGBColor[0, 0, 1], PointSize[0.03], 
     PointBox[{{3.875, 9.375}, {-1.125, 
      7.375}, {-11.125, -12.625}, {-9.125, -6.625}, {13.875, 
      9.375}, {-9.125, -2.625}, {10.875, -1.625}, {
      1.875, -2.625}}]}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  PlotRange->{{-15, 15}, {-15, 15}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.426531692802909*^9, 3.4265317214541073`*^9}, 
   3.4265333149955072`*^9, 3.4265334455832834`*^9, 3.42653351073697*^9, 
   3.426534157547037*^9, 3.4265345070195537`*^9, 3.4265346567849054`*^9, 
   3.4265347171917667`*^9, {3.4265347704483457`*^9, 3.4265347975072546`*^9}, {
   3.4265348867956448`*^9, 3.4265349043609023`*^9}, 3.4265351460183887`*^9, 
   3.426535310404765*^9, 3.426535362689947*^9, 3.426535470835453*^9, 
   3.4265355012191424`*^9, 3.4265356147724237`*^9, 3.4265361856132526`*^9}],

Cell[BoxData["\<\"scatterplot_dom.eps\"\>"], "Output",
 CellChangeTimes->{{3.426531692802909*^9, 3.4265317214541073`*^9}, 
   3.4265333149955072`*^9, 3.4265334455832834`*^9, 3.42653351073697*^9, 
   3.426534157547037*^9, 3.4265345070195537`*^9, 3.4265346567849054`*^9, 
   3.4265347171917667`*^9, {3.4265347704483457`*^9, 3.4265347975072546`*^9}, {
   3.4265348867956448`*^9, 3.4265349043609023`*^9}, 3.4265351460183887`*^9, 
   3.426535310404765*^9, 3.426535362689947*^9, 3.426535470835453*^9, 
   3.4265355012191424`*^9, 3.4265356147724237`*^9, 3.4265361857434397`*^9}]
}, Open  ]]
},
WindowSize->{784, 889},
WindowMargins->{{9, Automatic}, {Automatic, -4}},
ShowSelection->True,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 1062, 26, 396, "Input"],
Cell[CellGroupData[{
Cell[1655, 51, 20436, 501, 3431, "Input"],
Cell[CellGroupData[{
Cell[22116, 556, 584, 7, 27, "Print"],
Cell[22703, 565, 758, 13, 27, "Print"],
Cell[23464, 580, 540, 7, 27, "Print"],
Cell[24007, 589, 581, 7, 27, "Print"],
Cell[24591, 598, 775, 14, 27, "Print"],
Cell[25369, 614, 542, 7, 27, "Print"],
Cell[25914, 623, 746, 12, 27, "Print"],
Cell[26663, 637, 744, 12, 27, "Print"],
Cell[27410, 651, 542, 7, 27, "Print"],
Cell[27955, 660, 772, 13, 27, "Print"],
Cell[28730, 675, 539, 7, 27, "Print"],
Cell[29272, 684, 736, 12, 27, "Print"],
Cell[30011, 698, 542, 7, 27, "Print"],
Cell[30556, 707, 558, 7, 27, "Print"]
}, Open  ]],
Cell[31129, 717, 1007, 18, 307, "Output"],
Cell[32139, 737, 558, 7, 27, "Print"],
Cell[32700, 746, 1004, 18, 307, "Output"],
Cell[CellGroupData[{
Cell[33729, 768, 1744, 42, 72, "Print"],
Cell[35476, 812, 540, 7, 27, "Print"],
Cell[36019, 821, 615, 8, 27, "Print"]
}, Open  ]],
Cell[36649, 832, 2539, 56, 313, "Output"],
Cell[39191, 890, 1315, 34, 71, "Output"],
Cell[40509, 926, 1081, 22, 71, "Output"],
Cell[CellGroupData[{
Cell[41615, 952, 961, 20, 27, "Print"],
Cell[42579, 974, 539, 7, 27, "Print"],
Cell[43121, 983, 811, 14, 27, "Print"],
Cell[43935, 999, 542, 7, 27, "Print"],
Cell[44480, 1008, 1055, 20, 27, "Print"],
Cell[45538, 1030, 540, 7, 27, "Print"],
Cell[46081, 1039, 732, 12, 27, "Print"],
Cell[46816, 1053, 542, 7, 27, "Print"],
Cell[47361, 1062, 614, 8, 27, "Print"],
Cell[47978, 1072, 594, 8, 27, "Print"]
}, Open  ]],
Cell[48587, 1083, 1328, 25, 313, "Output"],
Cell[49918, 1110, 571, 7, 48, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
