(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6595,        175]
NotebookOptionsPosition[      6225,        160]
NotebookOutlinePosition[      6644,        176]
CellTagsIndexPosition[      6601,        173]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook illustrates a sphere and relates it to spherical coordinates.

A sphere of radius 1 is displayed.
Spherical coordinates are (r,theta, phi). In the Manipulate function below, \
you can see how changing theta moves the point along a constant latitude and \
changing phi moves the point along a constant longitude.

See Chapter 3: Coordinate Systems for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.4203744135498095`*^9, 3.420374441970677*^9}, {
  3.420374583153688*^9, 3.4203745898232784`*^9}, {3.4203753362465825`*^9, 
  3.4203753574070096`*^9}, {3.420376449006653*^9, 3.4203765319659424`*^9}},
 FormatType->"TextForm"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Output", " ", "results", " ", "to", " ", "folder", " ", "that", " ", 
    "this", " ", "file", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{
    "One", " ", "way", " ", "to", " ", "create", " ", "a", " ", "sphere", " ",
      "in", " ", "Mathematica", " ", "is", " ", "with", " ", "the", " ", 
     "primative"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "But", " ", "we", " ", "want", " ", "the", " ", "isoparametric", " ", 
     "lines", " ", "from", " ", "the", " ", "parametric", " ", "plot", " ", 
     "below"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Sphere", "[", "]"}], "]"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"pic", " ", "=", " ", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", "\[Phi]", "]"}], 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
        RowBox[{
         RowBox[{"Sin", "[", "\[Phi]", "]"}], 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Phi]", ",", "0", ",", 
        RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"ParametricPlot3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"Cos", "[", "\[Phi]", "]"}], 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
           RowBox[{
            RowBox[{"Sin", "[", "\[Phi]", "]"}], 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Phi]", ",", "0", ",", 
           RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}], ",", " ", 
         RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", " ", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", "0.09", "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"Cos", "[", "mytheta", "]"}], 
              RowBox[{"Sin", "[", "myphi", "]"}]}], ",", 
             RowBox[{
              RowBox[{"Sin", "[", "mytheta", "]"}], 
              RowBox[{"Sin", "[", "myphi", "]"}]}], ",", 
             RowBox[{"Cos", "[", "myphi", "]"}]}], "}"}], "]"}]}], "}"}], 
        "]"}]}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"myphi", ",", 
         RowBox[{"Pi", "/", "2"}]}], "}"}], " ", ",", "0", ",", "Pi"}], "}"}],
      ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"mytheta", ",", 
         RowBox[{"2", "*", "Pi"}]}], "}"}], ",", " ", "0", ",", " ", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<sphere_coords.eps\>\"", ",", "pic"}], "]"}], " ", 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.4203743064958735`*^9, 3.4203743183328943`*^9}, {
  3.420374378689683*^9, 3.4203743798313246`*^9}, {3.420374598445677*^9, 
  3.4203746549369073`*^9}, {3.4203748608429856`*^9, 3.4203748807716417`*^9}, {
  3.420374914420026*^9, 3.4203749353200784`*^9}, {3.4203751759560957`*^9, 
  3.4203752786737967`*^9}, {3.420375402451781*^9, 3.4203754073087645`*^9}, {
  3.4203755137718515`*^9, 3.420375533390061*^9}, {3.4203755871573744`*^9, 
  3.420375730904072*^9}, {3.420375833201168*^9, 3.420375871346018*^9}, {
  3.4203759278272333`*^9, 3.4203759574298*^9}, {3.4203760349212275`*^9, 
  3.4203760615194736`*^9}, {3.4203761257117777`*^9, 3.4203761529108877`*^9}, {
  3.42037618459645*^9, 3.4203762328758717`*^9}, {3.4203763536795793`*^9, 
  3.4203763578655987`*^9}, {3.420376405494085*^9, 3.4203764089991245`*^9}}]
},
WindowSize->{710, 621},
WindowMargins->{{6, Automatic}, {Automatic, 102}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 808, 21, 286, "Input"],
Cell[1379, 44, 4842, 114, 621, "Input"]
}
]
*)

(* End of internal cache information *)
