(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34030,        674]
NotebookOptionsPosition[     33457,        653]
NotebookOutlinePosition[     33876,        669]
CellTagsIndexPosition[     33833,        666]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates interpolation.
Figure 8.4 was generated with this notebook.

Input: data values (x,y)_i i=1,n ... Here we have selected 6 values from y = \
sqrt(x) 
Output: the interpolating polynomial to the input values. Here then, we have \
a degree 5 polynomial.


See Chapter 8: Data Fitting for details.

Updated July 2008\
\>", "Input",
 CellChangeTimes->{
  3.4259363142341566`*^9, {3.425936353931238*^9, 3.42593641716216*^9}, {
   3.42593809232092*^9, 3.4259381695920305`*^9}},
 FormatType->"TextForm"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "p", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Create", " ", "six", " ", 
      RowBox[{"(", 
       RowBox[{"x", ",", "y"}], ")"}], " ", 
      RowBox[{"values", "  ", "--"}], " ", "Notice", " ", "that", " ", "y"}], 
     " ", "=", " ", 
     RowBox[{"sqrt", 
      RowBox[{"(", "x", ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vals", " ", "=", " ", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"i", "^", "2"}], ",", "i"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}], "//", "N"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Let", " ", "Mathematica", " ", "create", " ", "an", " ", "interpolating",
      " ", "polynomial"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"p", "[", "x_", "]"}], "=", 
     StyleBox[
      RowBox[{"InterpolatingPolynomial", "[", 
       RowBox[{"vals", ",", "x"}], "]"}], "MR"]}], 
    StyleBox[";", "MR"]}]}]}]], "Input",
 CellChangeTimes->{{3.4259364202766385`*^9, 3.425936494222968*^9}, {
  3.425936660211648*^9, 3.4259366675421886`*^9}, {3.425936795005472*^9, 
  3.4259368041085615`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{
    "Plot", " ", "the", " ", "function", " ", "from", " ", "which", " ", 
     "the", " ", "\"\<vals\>\"", " ", "were", " ", "extracted", " ", "and", 
     " ", "the", " ", "interpolatin", " ", "polynomial"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"PLT", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SqrtBox["x"], ",", 
         RowBox[{"p", "[", "x", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "25"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
            RowBox[{"GrayLevel", "[", "0.5`", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Thickness", "[", "0.01`", "]"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
       RowBox[{"ColorOutput", "\[Rule]", "GrayLevel"}]}], "]"}]}], ")"}], " ",
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "data", " ", 
     "points"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"points", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"vals", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"PointSize", "[", "0.03`", "]"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
       RowBox[{"ColorOutput", "\[Rule]", "GrayLevel"}]}], "]"}]}], ")"}], " ",
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Put", " ", "the", " ", "plots", " ", "together"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"picfinal", "=", 
     RowBox[{"Show", "[", 
      RowBox[{"{", 
       RowBox[{"PLT", ",", "points"}], "}"}], "]"}]}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "a", " ", "postscript", " ", "file"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<sqrt_int.eps\>\"", ",", "picfinal"}], "]"}], ";"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.425936530425024*^9, 3.4259365498429456`*^9}, {
  3.4259366714277763`*^9, 3.4259367447632275`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0.5], Thickness[0.01], LineBox[CompressedData["
1:eJwVy3k41IkfB3C3qWUxU0p5JEcahMlgKnw+W0TZFKlItBsaZ+RoyZHrt7Il
RT+Skgix1uQ+fiHLslhEiag1jhy5xoyJMPy+/fF+3s/reT/v3Zd8bd1EhISE
rhD51iqJguwMpaemxfn0sQ9MC6gkUXf5uN+AwTCboBbPCmgILnq21z0RjOQv
e1aX1kOy4dgF6TupkJ/+Q2i3RyM0611lSrg/gW71zR1Zns0QtnWjaiMzG+T+
MKpckWmFlCRz07WEPPj7WqSvfWA7/H27x5LPZIHMzWcRT0q7gBMrNRFcUAwB
vi4i/K7XEN7Ioi5lloLf4eigpqpuSMEvRbyESjBdNhhv9ngDrQdjqmeY9WDK
nctK83wHvxtTIgxYr8B0l0GU4c4+WBh0fRJY0ADk/HPiZc19ELGDNMLNbIRQ
y/ZYrsx7SE21Zs4ntICjxhTvVOAgtN0bvDrJ7IL6ty9E00qH4OaDlNZk2msw
YUR1Vmxng7Y7nNdnvYadWeEfi86ywV/yXqh/QTeYtjksLnSxYd2cXsfJfAOa
hx8mNlQNw/bG60dmE/rg+V4uNnmMwvFaSetx5hCEJjLtUz3HgbZxiS/PGYKk
ayX5gofjcFv5YqeqMRtGf84zELSNQ+ClmiC7JjYwJip53dQJMBv3ayp/Owxp
X/Z5kEcnYGT248/B/FHQJ0VEFJlPgbKg8pHAcBJc1WZj9r6bhi0ZbpytoZPQ
H566pCeYBhJQzHTqJ2H39R8sRNVmYD7yyrSzxRTQbbU4pKszUCemfvDVuc+w
oezyE4s0C05SSX3RwTNQ2enWIaM7Bx3ShpvEnDhQWRisAzoc6LEiP+gM40CK
ion3vAkH+uPn9qQ94sDpAN17d09wYEw8z0znAwfUae+Nc705sCbYFmnvuACi
/tQc1QIOaM59/VLowIVDByULb6oswM3O2rEzZxehv3w54fMmLhxONH+Vd3IZ
aIPFmstVPHDTXZGmSQuhucDMi5P/BU5Q3RbkLcRwjj6ctCfkK5S8DQ9qZZAw
yV60S69vFQ6RNVliN6RQYFb2LHr/OjBXkx7n2MuiyB8ksry2EPo2T+izTpCR
NCUcP6cojL+dl1AXeG9Bkd8cC3kUEXRpCb1Mc5fHNnZsh8G8CDZIKth4OWxH
OvNi/uxLUaTJRaZMBe5AfYfQDOlkMbzIM9G29lZETt/KsMVpcczM+EtxKUEJ
j2xvLrJQlMCSOwcHe2yVUfTWv1JjAxIYUGNy6vGPu9FHtPsrI04S69pyuPGO
KqgY49dZbUxCd4sDtR72qvjvSnpF8DAJ05/Tyr081XCUrCBlnbgJ7/Jqo/x+
Uces4uT+VIPN+Kkg6Jq7/x6kZyu5buvYjI1Hkx5ER2ugF1fyUZ7Pdyh0cmAk
MXIvDpPEGLZCUriBFcKZIVTkeeYexwQpjNu2dKInThMXX0zzlVWl0fe8y59L
MVpYXi1ZdbpQGtlRdFf4rzbuslS/a2H6PVKS0wbin+5DzQrlAE7b95gjqxnS
kq6DHkJyq5NWMvjKf5e5xu+6eOvXbc6/9MpghnKmoomdHoZlbCmaoMpibdiK
kPtrPXRx0pGauiyLu60k11TP0XDAlvE/peeyWNZFvfX+LQ1L3n3Sp4zJ4u3m
dT1lp/14pqKTr6Ymh8kBU54/fdiPth/HqaoX5TBsq5KMioM+ltPjbQ48kMN8
qnhbIFsfX56jss72yqHEorBCgzMdLXs/r+RIkzFPrzgiY4KOd6ajHk0cIyP1
UoG1wMcAU3i9jjaxZBw8Vl1yZtoAL+S3h2rWkLEn+/o+CDDEkyzuOzaPjMul
NsYqXENk6fodUqdScKPKv/zXK0YoJFVm3XWBglZ6R83D+Ea4pb6m4vB9CrY4
6Xp4BTBQvof7NLCFgnGCtuzpVQamYbCe8zoF7e4r8FcJp3dPV7oSVtZyPyq1
xsBWdAIvwjX24lPahCuqD1gHE54pBZ0rhKXl33slET7lWVbFIXzjenFuM+Ed
fY87+AIGUoRbd+huUHDcZ0ZJYp2B7Y7LTw0Il4od8pMnvHhfnWpM+Mf9/WQj
whlZIUbHCN9IINsHE07UItm5EB47EjeyQriWX3c7lfCLgV797zYY6M/4h5JB
OPyq2n92Eq526Hv4jLD8kwYNY8JijInnxYSPrax6hxNudZltav+23ztel0DY
PH3KqofwiEaaTAZh1+LRnn7CYWcMS+oI3w3pZn8ibDkTK9pFOEvrL+YM4a0x
b+yGCDu/rJjjfvsrqOTOE27Ryg36Srjohd/SBuGhkOS1DcL/Bz1cQcc=
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[0.01], 
    LineBox[CompressedData["
1:eJwV13k81F0XAPCxZMsykiWPEGWZxRKzPJR7FCVJErKWkrUsWQrxUBKpkFRS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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  ColorOutput->GrayLevel,
  PlotRange->{{0, 25}, {0., 4.999999948979592}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4259367478977346`*^9, 3.425936807653659*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointSize[0.03], 
    PointBox[{{0., 0.}, {1., 1.}, {4., 2.}, {9., 3.}, {16., 4.}, {25., 
     5.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  ColorOutput->GrayLevel,
  PlotRange->{{0., 25.}, {0., 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4259367478977346`*^9, 3.4259368076837025`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], Thickness[0.01], LineBox[CompressedData["
1:eJwVy3k41IkfB3C3qWUxU0p5JEcahMlgKnw+W0TZFKlItBsaZ+RoyZHrt7Il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      "]]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], Thickness[0.01], 
     LineBox[CompressedData["
1:eJwV13k81F0XAPCxZMsykiWPEGWZxRKzPJR7FCVJErKWkrUsWQrxUBKpkFRS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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.03], 
     PointBox[{{0., 0.}, {1., 1.}, {4., 2.}, {9., 3.}, {16., 4.}, {25., 
      5.}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  ColorOutput->GrayLevel,
  PlotRange->{{0, 25}, {0., 4.999999948979592}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4259367478977346`*^9, 3.425936807733774*^9}]
}, Open  ]]
},
WindowSize->{799, 803},
WindowMargins->{{34, Automatic}, {36, Automatic}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 678, 22, 264, "Input"],
Cell[1249, 45, 1516, 41, 202, "Input"],
Cell[CellGroupData[{
Cell[2790, 90, 3348, 84, 397, "Input"],
Cell[6141, 176, 13296, 226, 262, "Output"],
Cell[19440, 404, 553, 15, 262, "Output"],
Cell[19996, 421, 13445, 229, 262, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
