(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31974,        665]
NotebookOptionsPosition[     31329,        641]
NotebookOutlinePosition[     31747,        657]
CellTagsIndexPosition[     31704,        654]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates stability problems with high degree polynomial \
interplolation.
Changing one data value just a bit can cause the interpolant's behavior to \
change significantly.
See \"eps\" below. The first cell allows you to change eps manually; the \
second cell is an animated version


See Chapter 2: Computational Basics for details.

Updated May 2008\
\>", "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.4204055745571375`*^9, 3.4204055974901133`*^9}, {
   3.420406873815379*^9, 3.4204068904392834`*^9}, {3.420406964285469*^9, 
   3.420406969192525*^9}, 3.4204815251777678`*^9, {3.4204819540043907`*^9, 
   3.420482084802469*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Create", " ", "a", " ", "set", " ", "of", " ", "20", " ", "data", " ", 
     "points", " ", 
     RowBox[{"(", 
      RowBox[{"x", ",", "y"}], ")"}], " ", "where", " ", "x", " ", "ranges", 
     " ", "from"}], " ", "-", 
    RowBox[{"1", " ", "to", " ", "1"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"vals", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"i", "/", "10"}]}], ",", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"1.0", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"i", "/", "10."}]}], ")"}], "^", "2"}]}], "]"}]}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", "20"}], "}"}]}], "]"}], "//", "N"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Change", " ", "one", " ", "value", " ", "by", " ", "just", " ", "a", " ",
      
     RowBox[{"bit", " ", "--"}], " ", "just", " ", "0.001", " ", "changes", 
     " ", "the", " ", 
     RowBox[{"interpolant", "!"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Let", " ", "eps", " ", "range", " ", "from", " ", "0", " ", "to", " ", 
     "0.01"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eps", " ", "=", " ", "0.00005"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vals", "[", 
      RowBox[{"[", 
       RowBox[{"10", ",", "2"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"vals", "[", 
       RowBox[{"[", 
        RowBox[{"10", ",", "2"}], "]"}], "]"}], "+", "eps"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotpts", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.03", "]"}], ",", 
        RowBox[{"Point", "[", "vals", "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotspecial", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.03", "]"}], ",", " ", "Red", ",", " ", 
        RowBox[{"Point", "[", 
         RowBox[{"vals", "[", 
          RowBox[{"[", "10", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Construct", " ", "the", " ", "interpolating", " ", "polynomial", " ", 
     "to", " ", "the", " ", "input", " ", "function", " ", "values"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"p", "[", "x_", "]"}], "=", 
     RowBox[{"InterpolatingPolynomial", "[", 
      RowBox[{"vals", ",", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Plot", " ", "the", " ", "polynomial", " ", "over"}], " ", "-", 
      "1"}], ",", "1"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotpoly", " ", "=", " ", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"p", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Thickness", "[", "0.01", "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
    "plotpts", ",", " ", "plotpoly", ",", " ", "plotspecial", ",", " ", 
     RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.420405612091109*^9, 3.4204057339863853`*^9}, {
  3.4204058363836255`*^9, 3.420405897401365*^9}, {3.4204059733906317`*^9, 
  3.420406008190672*^9}, {3.4204061526383777`*^9, 3.4204062364789343`*^9}, {
  3.4204062664820766`*^9, 3.4204062780587234`*^9}, {3.420406318136352*^9, 
  3.420406437147482*^9}, {3.4204064706356354`*^9, 3.4204065075687428`*^9}, {
  3.4204065406463056`*^9, 3.4204065825064974`*^9}, {3.4204066197500515`*^9, 
  3.420406644085043*^9}, {3.420406692354451*^9, 3.420406726623728*^9}, {
  3.420406802963499*^9, 3.4204068293814864`*^9}, {3.4204069009844465`*^9, 
  3.42040695099636*^9}, {3.42046457278885*^9, 3.4204645819920835`*^9}, {
  3.4204646599942446`*^9, 3.4204646601644897`*^9}, {3.420465265215742*^9, 
  3.4204652656663904`*^9}, {3.4204675582629824`*^9, 3.4204676113693457`*^9}, {
  3.420467669833413*^9, 3.420467682882176*^9}, {3.4204820156730657`*^9, 
  3.420482015833296*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {PointSize[0.03], 
    PointBox[{{-1., 0.}, {-0.9, 0.4358898943540673}, {-0.8, 
     0.5999999999999999}, {-0.7, 0.714142842854285}, {-0.6, 0.8}, {-0.5, 
     0.8660254037844386}, {-0.4, 0.9165151389911681}, {-0.3, 
     0.9539392014169457}, {-0.2, 0.9797958971132712}, {-0.1, 
     0.99503743710662}, {0., 1.}, {0.1, 0.99498743710662}, {0.2, 
     0.9797958971132712}, {0.3, 0.9539392014169457}, {0.4, 
     0.9165151389911679}, {0.5, 0.8660254037844386}, {0.6, 
     0.7999999999999999}, {0.7, 0.7141428428542849}, {0.8, 
     0.5999999999999999}, {0.9, 0.43588989435406705`}, {1., 0.}}]}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], Thickness[0.01], LineBox[CompressedData["
1:eJwt2Xk0Vd8XAHCJFBHJV1LmFMkcTdpIKmUsMlSUUDIlY2VIpjQJGcpQUaHM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      "]]}}, 
   {RGBColor[1, 0, 0], PointSize[0.03], PointBox[{-0.1, 0.99503743710662}]}},
  Axes->True]], "Output",
 CellChangeTimes->{{3.420406228787875*^9, 3.420406237019712*^9}, 
   3.420406279330552*^9, {3.420406334239507*^9, 3.4204063752985473`*^9}, 
   3.420406508139563*^9, 3.4204065608653793`*^9, {3.420406728476392*^9, 
   3.4204067369185314`*^9}, {3.420406813628835*^9, 3.420406830422984*^9}, {
   3.4204069218945136`*^9, 3.4204069402208652`*^9}, 3.4204646618469086`*^9, {
   3.4204675489095325`*^9, 3.4204676127012606`*^9}, {3.4204676708749104`*^9, 
   3.4204676835731697`*^9}, 3.420481552467008*^9, 3.420654388941296*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\

Here is a version with the Manipulate function.\
\>", "Input",
 CellChangeTimes->{{3.4204816556654*^9, 3.4204816814324512`*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "vals", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Create", " ", "a", " ", "set", " ", "of", " ", "20", " ", "data", " ", 
      "points", " ", 
      RowBox[{"(", 
       RowBox[{"x", ",", "y"}], ")"}], " ", "where", " ", "x", " ", "ranges", 
      " ", "from"}], " ", "-", 
     RowBox[{"1", " ", "to", " ", "1"}]}], " ", "*)"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vals", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"i", "/", "10"}]}], ",", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"1.0", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"i", "/", "10."}]}], ")"}], "^", "2"}]}], "]"}]}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", "20"}], "}"}]}], "]"}], "//", "N"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"originalval", " ", "=", " ", 
     RowBox[{"vals", "[", 
      RowBox[{"[", 
       RowBox[{"10", ",", "2"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Modify", " ", "one", " ", "data", " ", "value", " ", "and", " ", 
     "regenerate", " ", "the", " ", "point", " ", "plot"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"modifyptplot", "[", "eps_", "]"}], " ", ":=", "  ", 
    RowBox[{"(", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"vals", "[", 
        RowBox[{"[", 
         RowBox[{"10", ",", "2"}], "]"}], "]"}], "=", 
       RowBox[{"originalval", "+", "eps"}]}], ";", 
      RowBox[{"Return", "[", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", "0.03", "]"}], ",", " ", "Red", ",", " ", 
          
          RowBox[{"Point", "[", 
           RowBox[{"vals", "[", 
            RowBox[{"[", "10", "]"}], "]"}], "]"}]}], "}"}], "]"}], "]"}], 
      ";"}], ")"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "REgeneterate", " ", "the", " ", "polynomial", " ", "interpolant", " ", 
     "and", " ", "plot", " ", "of", " ", "the", " ", "function"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"modifyplotpoly", "[", "eps_", "]"}], " ", ":=", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"p", "[", "x_", "]"}], "=", 
       RowBox[{"InterpolatingPolynomial", "[", 
        RowBox[{"vals", ",", "x"}], "]"}]}], ";", 
      RowBox[{"Return", "[", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"p", "[", "x", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"Thickness", "[", "0.01", "]"}]}]}], "]"}], "]"}], ";"}], 
     ")"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Show", "[", 
      RowBox[{"plotpts", ",", " ", 
       RowBox[{"modifyptplot", "[", "eps", "]"}], ",", " ", 
       RowBox[{"modifyplotpoly", "[", "eps", "]"}], ",", " ", 
       RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.2"}], ",", " ", "1.2"}], "}"}], ",", " ", 
          RowBox[{"{", " ", 
           RowBox[{
            RowBox[{"-", "0.5"}], ",", " ", "2.0"}], "}"}]}], "}"}]}]}], 
      "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eps", ",", " ", "0.0"}], "}"}], ",", 
       RowBox[{"-", "0.01"}], ",", "0.01", ",", " ", "0.00005"}], "}"}]}], 
    "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.4204646447623425`*^9, 3.420464677569517*^9}, {
   3.4204649797652845`*^9, 3.4204649875164304`*^9}, {3.4204650181204367`*^9, 
   3.42046504052265*^9}, {3.4204652078833027`*^9, 3.420465257865173*^9}, {
   3.420465295268957*^9, 3.4204653820437326`*^9}, {3.420465596882656*^9, 
   3.420465612875653*^9}, {3.420465881672163*^9, 3.4204658995979395`*^9}, {
   3.42046596601344*^9, 3.420466005440133*^9}, {3.4204660503246737`*^9, 
   3.4204660685508814`*^9}, 3.420466120135056*^9, {3.4204661594916477`*^9, 
   3.420466253787238*^9}, {3.4204663820416594`*^9, 3.4204664446116304`*^9}, {
   3.4204665063003345`*^9, 3.420466528011554*^9}, 3.4204665592664957`*^9, {
   3.420466797889619*^9, 3.4204669119836783`*^9}, {3.42046696210575*^9, 
   3.42046698447792*^9}, {3.4204670378046*^9, 3.420467084401603*^9}, {
   3.420467382970925*^9, 3.420467403510459*^9}, {3.4204674628858366`*^9, 
   3.4204675333571696`*^9}, {3.420467647451229*^9, 3.420467650956269*^9}, {
   3.420467720636464*^9, 3.4204677237008705`*^9}, {3.420467901967205*^9, 
   3.420467906754088*^9}, 3.420467973890626*^9, {3.420468005425971*^9, 
   3.4204680803637266`*^9}, {3.4204681106873293`*^9, 
   3.4204681754304256`*^9}, {3.4204682127340655`*^9, 
   3.4204682147069025`*^9}, {3.4204682577688227`*^9, 
   3.4204682891439376`*^9}, {3.4204683645824127`*^9, 3.420468446960867*^9}, {
   3.420481600365883*^9, 3.4204816523205905`*^9}, {3.4204816851678224`*^9, 
   3.4204817956767263`*^9}, {3.4204818474812174`*^9, 3.420481847581362*^9}, {
   3.420481892355744*^9, 3.4204818945288687`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`eps$$ = 0.0010500000000000006`, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`eps$$], 0.}, -0.01, 0.01, 0.00005}}, 
    Typeset`size$$ = {360., {191., 196.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`eps$198$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`eps$$ = 0.}, 
      "ControllerVariables" :> {
        Hold[$CellContext`eps$$, $CellContext`eps$198$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[$CellContext`plotpts, 
        $CellContext`modifyptplot[$CellContext`eps$$], 
        $CellContext`modifyplotpoly[$CellContext`eps$$], Axes -> True, 
        PlotRange -> {{-1.2, 1.2}, {-0.5, 2.}}], 
      "Specifications" :> {{{$CellContext`eps$$, 0.}, -0.01, 0.01, 0.00005}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {251., 256.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.4204684277232046`*^9, 3.420468476643549*^9}, 
   3.4204815575142655`*^9, 3.420481635566499*^9, {3.4204818066825523`*^9, 
   3.420481901078286*^9}, 3.4204819415665054`*^9, {3.4206544015794687`*^9, 
   3.4206544208071165`*^9}, 3.420654451551325*^9}]
}, Open  ]]
},
WindowSize->{803, 737},
WindowMargins->{{22, Automatic}, {Automatic, 0}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 813, 22, 262, "Input"],
Cell[CellGroupData[{
Cell[1406, 47, 4802, 119, 482, "Input"],
Cell[6211, 168, 17221, 284, 219, 9036, 150, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[23447, 455, 164, 5, 58, "Input"],
Cell[CellGroupData[{
Cell[23636, 464, 5702, 134, 482, "Input"],
Cell[29341, 600, 1972, 38, 534, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
