(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16525,        453]
NotebookOptionsPosition[     16115,        437]
NotebookOutlinePosition[     16534,        453]
CellTagsIndexPosition[     16491,        450]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\


Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook demonstrates quadratic forms and contour plots.
Three quadratic forms are created: an elliptic paraboloid, a hyperbolic \
paraboloid, and a cylindrical paraboloid.

Figure 11.7 was created with this notebook.

See Chapter 11: Computing with multivariate functions for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{
  3.420120310065195*^9, {3.4201204066741123`*^9, 3.420120439571416*^9}, {
   3.420120566323677*^9, 3.420120586983384*^9}, {3.4201206273514304`*^9, 
   3.4201206553717213`*^9}, {3.426363667454938*^9, 3.4263636806238737`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Set", " ", "output", " ", "folder", " ", "to", " ", "folder", " ", "this",
     " ", "file", " ", "is", " ", "in"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "xxxx"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"data", "=", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.`", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "2"}]}], "}"}]}], "}"}], "]"}]}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"A1", "=", 
    RowBox[{"data", ".", 
     RowBox[{"Transpose", "[", "data", "]"}]}]}], "\[IndentingNewLine]", "\n",
    
   RowBox[{"Eigenvalues", "[", "A1", "]"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e1", ",", "e2"}], "}"}], "=", 
     RowBox[{"Eigenvectors", "[", "A1", "]"}]}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<e1 = \>\"", ",", "e1", ",", "\"\< e2=\>\"", ",", "e2"}], 
    "]"}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Form", " ", "an", " ", "elliptic", " ", "paraboloid"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f1", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ".", "A1", ".", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Form", " ", "a", " ", "hyperbolic", " ", "paraboloid"}], " ", 
    "*)"}], "\n", 
   RowBox[{
    RowBox[{"A2", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.`", ",", 
         RowBox[{"-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f2", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ".", "A2", ".", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}]}], ";"}], "\n", "\[IndentingNewLine]",
    
   RowBox[{"(*", " ", 
    RowBox[{"Form", " ", "a", " ", "cylindrical", " ", "paraboloid"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2.`", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"f3", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ".", "A3", ".", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "function", " ", "plots"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "color", " ", "version", " ", "to", " ", "view", 
     " ", "and", " ", "a", " ", "gray", " ", "scale", " ", "version", " ", 
     "for", " ", "the", " ", "postscript", " ", "file"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"p1", "=", 
    RowBox[{"Plot3D", "[", 
     RowBox[{
      RowBox[{"f1", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "3"}], ",", "0.5`"}], "}"}]}], ",", " ", 
      RowBox[{"PlotPoints", "\[Rule]", "90"}]}], "]"}]}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p1gray", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"f1", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "3"}], ",", "0.5`"}], "}"}]}], ",", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"ColorData", "[", "\"\<GrayTones\>\"", "]"}]}], ",", " ", 
       RowBox[{"PlotPoints", "\[Rule]", "90"}], ",", 
       RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], ";"}], 
   "\n", "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"p2", "=", 
    RowBox[{"Plot3D", "[", 
     RowBox[{
      RowBox[{"f2", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "3"}], ",", "0.5`"}], "}"}]}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "90"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"p2gray", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"f2", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "3"}], ",", "0.5`"}], "}"}]}], ",", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"ColorData", "[", "\"\<GrayTones\>\"", "]"}]}], ",", " ", 
       RowBox[{"PlotPoints", "\[Rule]", "90"}], ",", 
       RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"p3", "=", 
    RowBox[{"Plot3D", "[", 
     RowBox[{
      RowBox[{"f3", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "3"}], ",", "0.5`"}], "}"}]}], ",", " ", 
      RowBox[{"PlotPoints", "\[Rule]", "90"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p3gray", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"f3", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "3"}], ",", "0.5`"}], "}"}]}], ",", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"ColorData", "[", "\"\<GrayTones\>\"", "]"}]}], ",", " ", 
       RowBox[{"PlotPoints", "\[Rule]", "90"}], ",", 
       RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "contour", " ", "plots", " ", "of", " ", "each"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "color", " ", "version", " ", "to", " ", "view", 
     " ", "and", " ", "a", " ", "grayscale", " ", "version", " ", "for", " ", 
     "the", " ", "ps", " ", "output"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"c1", "=", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"f1", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}]}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c1gray", "=", 
     RowBox[{"ContourPlot", "[", 
      RowBox[{
       RowBox[{"f1", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"ColorData", "[", "\"\<GrayTones\>\"", "]"}]}], ",", " ", 
       RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"c2", "=", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"f2", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c2gray", "=", 
     RowBox[{"ContourPlot", "[", 
      RowBox[{
       RowBox[{"f2", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"ColorData", "[", "\"\<GrayTones\>\"", "]"}]}], ",", " ", 
       RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"c3", "=", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"f3", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c3gray", "=", 
     RowBox[{"ContourPlot", "[", 
      RowBox[{
       RowBox[{"f3", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"ColorData", "[", "\"\<GrayTones\>\"", "]"}]}], ",", " ", 
       RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Arrange", " ", "the", " ", "gray", " ", "scale", " ", "images", " ", 
     "in", " ", "a", " ", "grid", " ", "for", " ", "the", " ", "ps", " ", 
     "output"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"barray", "=", 
     RowBox[{"GraphicsGrid", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p1gray", ",", "p2gray", ",", "p3gray"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"c1gray", ",", "c2gray", ",", "c3gray"}], "}"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Show", "[", "barray", "]"}], " ", "*)"}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "file"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<threecontours.eps\>\"", ",", "barray"}], "]"}], ";"}], " ",
     "*)"}]}]}]], "Input",
 CellChangeTimes->{
  3.420119905863982*^9, {3.420119956606947*^9, 3.4201199588802156`*^9}, {
   3.4201200313744574`*^9, 3.420120033357309*^9}, {3.4201206796566415`*^9, 
   3.4201208581232643`*^9}, {3.4201209008747377`*^9, 
   3.4201209191009455`*^9}, {3.4201209807596064`*^9, 3.420121078560237*^9}, {
   3.420121287560765*^9, 3.420121300990075*^9}, {3.4201220777169533`*^9, 
   3.4201221210192194`*^9}, {3.420122271405464*^9, 3.420122327235744*^9}, {
   3.42012247760196*^9, 3.4201224797350273`*^9}, {3.420123350336891*^9, 
   3.420123357937821*^9}, {3.420123475046214*^9, 3.4201234802637167`*^9}, {
   3.420123510467147*^9, 3.4201239225196495`*^9}, {3.420123967464277*^9, 
   3.4201239767275968`*^9}, {3.420127273918725*^9, 3.42012727666267*^9}}],

Cell[BoxData["-"], "Input"]
},
WindowSize->{774, 857},
WindowMargins->{{21, Automatic}, {Automatic, 33}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 726, 21, 304, "Input"],
Cell[1297, 44, 14784, 389, 2139, "Input"],
Cell[16084, 435, 27, 0, 48, "Input"]
}
]
*)

(* End of internal cache information *)
