(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     60232,       1122]
NotebookOptionsPosition[     59741,       1103]
NotebookOutlinePosition[     60161,       1119]
CellTagsIndexPosition[     60118,       1116]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook illustrates a transfer function.
This example is meant to isolate blood in a CT scan, and the transfer \
function is superimposed over the scan's histogram.  

Figures  15.10 was created with this notebook. See the figure caption for a \
complete description of this notbook.

See Chapter 15 : Volume Visualization for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.4269883096457777`*^9, 3.426988344806336*^9}, {
  3.4269884032503743`*^9, 3.42698841867255*^9}, {3.426989103377107*^9, 
  3.4269891482215905`*^9}, {3.4269891927756557`*^9, 3.4269891959201775`*^9}, {
  3.4269893570719023`*^9, 3.426989395437069*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "the", " ", "output", " ", "folder"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Create", " ", "functions", " ", "to", " ", "define", " ", "the", " ", 
      "transfer", " ", "function", " ", "for", " ", "blood"}], ",", " ", 
     "bones", ",", " ", "etc"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], "=", 
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "3"}], ")"}], "2"]}]], 
      SqrtBox[
       RowBox[{"2", " ", "\[Pi]"}]]]}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"f2", "[", "x_", "]"}], "=", 
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "3"}], ")"}], "4"]}]], 
      SqrtBox[
       RowBox[{"2", " ", "\[Pi]"}]]]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Transfer", " ", "function", " ", "for", " ", "blood", " ", "histogram"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bloodplot", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"f2", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "6"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.0001`", "]"}], ",", 
          RowBox[{"GrayLevel", "[", "0.6`", "]"}]}], "}"}]}], ",", 
       RowBox[{"FillingStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"GrayLevel", "[", "0.6`", "]"}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
       RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "CT", " ", 
     "values", " ", "for", " ", "all", " ", "other", " ", "readings"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ctallplot", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"f", "[", "x", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "6"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.0001`", "]"}], ",", 
          RowBox[{"GrayLevel", "[", "0.8`", "]"}]}], "}"}]}], ",", 
       RowBox[{"FillingStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"GrayLevel", "[", "0.8`", "]"}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<CT Values\>\"", ",", "\"\<Frequency / Color Value\>\""}], 
         "}"}]}], ",", 
       RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Here", " ", "we", " ", "are", " ", "making", " ", "up", " ", "the", " ", 
     "transfer", " ", "functions", " ", "by", " ", "looking", " ", "at", " ", 
     "the", " ", "CT", " ", "histograms", " ", "from", " ", "above"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"redlst", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.2`", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.4`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "1.`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bluelst", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "0.04`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.6`", ",", 
         RowBox[{"-", "0.04`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.8`", ",", "0.96`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "0.96`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"oplst", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0.04`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.13`", ",", "0.04`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.19`", ",", "0.45`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.83`", ",", "0.45`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.89`", ",", "1.04`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "1.04`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "transfer", 
     " ", "functions"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"colorplot", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"redlst", ",", "bluelst", ",", "oplst"}], "}"}], ",", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.`", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.0001`", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.5`", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.0001`", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.3`", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.00001`", "]"}], ",", 
            RowBox[{"Dashing", "[", 
             RowBox[{"{", "0.03`", "}"}], "]"}]}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotMarkers", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\[FilledSquare]", ",", " ", "\[FilledSquare]", ",", " ", 
          "\[FilledSquare]"}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Put", " ", "it", " ", "all", " ", "together"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"ctallplot", ",", "bloodplot", ",", "colorplot", ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "postscript", " ", "file"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<transfer_fct.eps\>\"", ",", "%"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4269884242706003`*^9, 3.426988524054082*^9}, {
  3.4269885767298255`*^9, 3.426988636706067*^9}, {3.426988709630928*^9, 
  3.42698871168388*^9}, {3.426988759272309*^9, 3.426988779301109*^9}, {
  3.42698883636316*^9, 3.4269888517252493`*^9}, {3.4269889601311293`*^9, 
  3.426988966780691*^9}, {3.4269892264540834`*^9, 3.426989346496696*^9}}],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJw1mXk4lF8bx2WbQUXMkpJkX9pQQrhv6Zcs2SqEpEJRliS7Ymwt9q3sKYVK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    "], {{{}, 
      {GrayLevel[0.8], EdgeForm[None], 
       GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwl1He0z2UcB/B77Z3IXqEIGdllj9AS15Z57XWvkcwohUJmtKmQdlmRTVlR
2tOmjFJoIJHX59w/Xufzft7fe37n+X6f59ySyalJKekSEhISmZqYNqckpuVq
8mSzFg9zzrqyOZKV8inKykPiufwWRyhh3Yf75UE8xz5y6tpQVW7JQJ7lM3Lo
k7hNHs+bHKa4rjf3yQN4hk/JrmtNFXkcb3CIYrpe3Cv3ZwF7yaZrRWV5LK9z
kKK6ZO6R+zGfPWSN/VNJHsMyDlBE15O75b48zSdk0bWkojya19hPYV0P7pL7
MI/dZI534la5Bb2Zyy4yxf6pIDenF3PYScbYK+XlZiQzmx1kiH1RTr4lzoYy
3MxNlKYUJbkxzim+L3fSk1lsJ33sl2JyU3owk49Jp29BUXkUS/mJQrruNJG7
8xQfxb3SNaeIvIKTsSfrwTwkL+FHClp3o7H8Hj/Hfq0HRC//Sjk5lRnytoS0
S9uMwuJZKskPslyuZo7hRLy/OSjurVzDHMcZ+ZH4xgxjsfWkuH+M4gfrCWYB
utLI+nGzJuP53frROD+G8671Y3G3Gc1x64lmKfrHb1hXN8dyOs7HTGG6XCW+
BVvl/+M85ELmH1SUR/C+/Eucozww3lP+jfLyUF6Vvye/3IWG8jsci/O27he9
PI0tXI2z1RU0R/AK35FP9wAN5Lc5GnfFum/08pNs5gpN4vuYw3mZb7lB15n6
cmeeYBP/0Vif3xzGIr4hr64T9eROTGUjl2mkzxe/GX9HHq4nN9eRi5zkIDvZ
qEtHprCBf2nod7KadejAZNZziQaeZTHvoH2cMeu4SH3PMpu30y7Olw+5QD3P
MplDWcjXsT9dR2rLbeM+sZZ/Yl/6jGYqL/FVvIuuA7XkNnGfWMPfsVd9BjOF
F/ky3lvXPu6gnBT3lw/4K/avT28O4QW+iG+ka0cNuXXcR1bzZ7yTPv7vD+Z5
Po/vqWtLdbkVE1jFeWrrrwGySqYi
         "],
         VertexColors->None]]}, {}, {}}, {{}, {}, 
      {GrayLevel[0.8], Thickness[0.0001], LineBox[CompressedData["
1:eJwl1WW0VVUYBdBHd3fz6O5QLFDBVniIWChlIWGBYtAIStrdHQjYCiYYYBdg
gQom2JigMtfwx3zf2uuOcdn7nH0HhSMnFI0vVlBQMNufzN38+cV8lCkMpAdH
6ivztnw9YynO7rpfzceYyiB6MkRfhXfkGxhHCfrotpuPM40ienGUvirvyjcy
npLsofvNfILpDKY3Q/XVeE++iQmUYk/d7+aTzMi+cyaO1lfnfflmzqA0e+n+
MJ9iZvadM1GGvX32p/k0s7LH7J+y7OOzv8wVeXbZT/ZKOfr67G9zJRfn386+
KE8FKlKJylShKtWoTg1qUot+vmeH+QxzOCb7zdTX4AP5Fs6kNvvqdprPMpdj
c4ZMfU3WybdyFnXYT/eP+RyXcBwn65ryhfxgzpneuhbr5ds4m7rsr/vXfJ5L
OZ5TdIVslpfkWaS3rs0G+fY8e7kd2+RzGCO34Ct5Wb5f7siPcj36y/+ZLzBJ
7sK83BGzDd/J55s9GCafajZjKluszzO7MZOHcn6zA9P5wfpCsxez6Gc9zKzD
FD60PtfsygzuyPM22zON760vMHsyUT7dbMnX8mSzO8tzTrMTP8n1GZAfGy8a
83N/5bZslU/gNLk5X8pL827TW9flI/nOPAvGWrfiG/lhGnBAfsuskhdwYt51
pq4eH8t35Vw05EBdcVbLCxmed0sjDtKX4CV5ESPyPmhME5pSSDOa04KWtKI1
bWjLwb6jJC/LixmZZ0A7DtGX4hX5MkblDLTnUH1pXpUvZ3T2SwcO05dhjXwF
J2W/2b+uPp/Id+f905HDdWVZK1+Zu5595Uy6Bnwq35P3RieO0JXjNfmq3O3s
NXvXNWSjfG/uHp0ZqCvP6/LVuYfZf86ja8Qm+b7cF7owSFeBN+Rr8s5zppxR
15jP5PtzP+lKka4ib8rX5neTM9GNwfpKvCVfl3uY/eeZ6JrwufwAFzHOujXf
yo8wUe7Mz/nc7F3s//8PulvvAiFtpQ8=
        "]]}}}], GraphicsComplexBox[CompressedData["
1:eJxMm3k4lGEb9u172WbGUiFrooSy5XmuO2TNviZJlIQkRYgSkn0LyVIhoihb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    "], {{{}, 
      {GrayLevel[0.6], EdgeForm[None], 
       GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwt2Hfcl+MbxvGnaTeQjFBZDVHSlFFpl3ZRtNBORiGjQkZGJSsaMhKFsltW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         "],
         VertexColors->None]]}, {}, {}}, {{}, {}, 
      {GrayLevel[0.6], Thickness[0.0001], LineBox[CompressedData["
1:eJwl2AfYzuUbxvEXZUbDFpW9skn2nmXvkZWRyErDaFKiKFsLoeyGkQplk5XK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        "]]}}}], 
   GraphicsComplexBox[{{0., 0.}, {1.2, 0.}, {1.4, 1.}, {6., 1.}, {
    0., -0.04}, {4.6, -0.04}, {4.8, 0.96}, {6., 0.96}, {0., 0.04}, {1.13, 
    0.04}, {1.19, 0.45}, {4.83, 0.45}, {4.89, 1.04}, {6., 1.04}}, {{{}, {}, 
      {GrayLevel[0.], PointSize[0.0001], Thickness[0.01], 
       StyleBox[LineBox[{1, 2, 3, 4}],
        FontColor->GrayLevel[0.]]}, 
      {GrayLevel[0.5], PointSize[0.0001], Thickness[0.01], 
       LineBox[{5, 6, 7, 8}]}, 
      {GrayLevel[0.3], PointSize[0.00001], Thickness[0.01], Dashing[{0.03}], 
       LineBox[{9, 10, 11, 12, 13, 14}]}}, {
      {GrayLevel[0.], PointSize[0.0001], Thickness[0.01], 
       StyleBox[{InsetBox["\[FilledSquare]", 1], 
         InsetBox["\[FilledSquare]", 2], InsetBox["\[FilledSquare]", 3], 
         InsetBox["\[FilledSquare]", 4]},
        FontColor->GrayLevel[0.]]}, 
      {GrayLevel[0.5], PointSize[0.0001], Thickness[0.01], 
       InsetBox["\[FilledSquare]", 5], InsetBox["\[FilledSquare]", 6], 
       InsetBox["\[FilledSquare]", 7], InsetBox["\[FilledSquare]", 8]}, 
      {GrayLevel[0.3], PointSize[0.00001], Thickness[0.01], Dashing[{0.03}], 
       InsetBox["\[FilledSquare]", 9], InsetBox["\[FilledSquare]", 10], 
       InsetBox["\[FilledSquare]", 11], InsetBox["\[FilledSquare]", 12], 
       InsetBox["\[FilledSquare]", 13], 
       InsetBox["\[FilledSquare]", 14]}, {}}}]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"CT Values\"", TraditionalForm], 
    FormBox["\"Frequency / Color Value\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  Method->{"AxesInFront" -> True},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 CellChangeTimes->{3.426988858244624*^9, 3.42698922783607*^9}],

Cell[BoxData["\<\"transfer_fct.eps\"\>"], "Output",
 CellChangeTimes->{3.426988858244624*^9, 3.42698922801633*^9}]
}, Open  ]]
},
WindowSize->{739, 740},
WindowMargins->{{-13, Automatic}, {Automatic, 33}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 826, 21, 319, "Input"],
Cell[CellGroupData[{
Cell[1419, 46, 8705, 222, 1293, "Input"],
Cell[10127, 270, 49481, 827, 242, "Output"],
Cell[59611, 1099, 114, 1, 48, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
