(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26147,        528]
NotebookOptionsPosition[     25660,        509]
NotebookOutlinePosition[     26079,        525]
CellTagsIndexPosition[     26036,        522]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates theidea behind the trapezoid rule for integration.

Figures 8.3 was generated with this notebook.

See Chapter 8: Data Fitting for details.

Updated July 2008\
\>", "Input",
 CellChangeTimes->{{3.4263597131188817`*^9, 3.4263597404081216`*^9}, {
  3.426359786704693*^9, 3.4263598158265676`*^9}, {3.4263614985361853`*^9, 
  3.4263615037837315`*^9}, {3.42636155096157*^9, 3.4263615514823184`*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "output", " ", "folder"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "a", " ", "function"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], ":=", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"52", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], "+", "10"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Load", " ", "15", " ", "points"}], ",", " ", 
     RowBox[{"evaluated", " ", "from", " ", "the", " ", "function"}]}], " ", 
    "*)"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Points", " ", "are", " ", 
      RowBox[{"f", "[", "1", "]"}]}], ",", " ", 
     RowBox[{"f", "[", "2", "]"}], ",", " ", 
     RowBox[{"...", " ", 
      RowBox[{"f", "[", "15", "]"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "These", " ", "are", " ", "the", " ", "endpoints", " ", "of", " ", "a", 
     " ", "piecewise", " ", "linear", " ", "approximation"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pw", ":=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "15"}], "}"}]}], "]"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "function"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotf", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "15"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Thickness", "[", "0.01`", "]"}]}], ",", 
       RowBox[{"Ticks", "\[Rule]", "None"}], ",", " ", 
       RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "picewise", 
     " ", "linear", " ", "approximation"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotpw1", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"pw", ",", 
       RowBox[{"Ticks", "\[Rule]", "None"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"PointSize", "[", "0.02`", "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "line", " ", 
     "segments", " ", "connecting", " ", "the", " ", "15", " ", "function", 
     " ", "points"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotpw2", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"pw", ",", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", 
       RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Create", " ", "a", " ", "plot", " ", "of", " ", "lines", " ", 
      "connecting", " ", "the", " ", "15", " ", "points", " ", "on", " ", 
      "the", " ", "function", " ", "to", " ", "corresponding", " ", "points", 
      " ", "on", " ", "the", " ", "x"}], "-", "axis"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lines", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"i", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"f", "[", "i", "]"}]}], "}"}]}], "}"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "15"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Put", " ", "all", " ", "plots", " ", "together"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"pic", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{"plotf", ",", "plotpw1", ",", "plotpw2", ",", "lines"}], "}"}], 
     "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "a", " ", "postscript", " ", "file"}], 
    " ", "*)"}], "\n", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<trapezrule.eps\>\"", ",", "pic"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4263598185104275`*^9, 3.4263598638656445`*^9}, {
  3.4263610041452866`*^9, 3.4263612765369663`*^9}, {3.426361312959339*^9, 
  3.4263613130795116`*^9}, {3.4263613483402147`*^9, 3.4263613487107472`*^9}, {
  3.42636138497289*^9, 3.4263613952276354`*^9}, {3.426361435145034*^9, 
  3.426361485377264*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], Thickness[0.01], LineBox[CompressedData["
1:eJwV13k4VG8bB3BKtmwz1rINM2Mf2YlybiXJbuzrSNZsEymEkERESbZUfsqS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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], 
     PointBox[{{1., 54.756491210010616`}, {2., 61.28346619493545}, {3., 
      26.338240419113095`}, {4., -13.353729756012264`}, {
      5., -14.864062282483196`}, {6., 31.470394093655855`}, {7., 
      93.16330313337703}, {8., 125.44662882441585`}, {9., 
      112.43016123257135`}, {10., 81.71090223375278}, {11., 
      79.00050925936341}, {12., 126.09820826397738`}, {13., 
      200.84868591498534`}, {14., 257.51158249613326`}, {15., 
      268.8149676881701}}]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{1., 54.756491210010616`}, {2., 61.28346619493545}, {3., 
      26.338240419113095`}, {4., -13.353729756012264`}, {
      5., -14.864062282483196`}, {6., 31.470394093655855`}, {7., 
      93.16330313337703}, {8., 125.44662882441585`}, {9., 
      112.43016123257135`}, {10., 81.71090223375278}, {11., 
      79.00050925936341}, {12., 126.09820826397738`}, {13., 
      200.84868591498534`}, {14., 257.51158249613326`}, {15., 
      268.8149676881701}}]}}, {
    LineBox[NCache[{{1, 0}, {1, 11 + 52 Sin[1]}}, {{1, 0}, {
       1, 54.756491210010616`}}]], 
    LineBox[NCache[{{2, 0}, {2, 14 + 52 Sin[2]}}, {{2, 0}, {
       2, 61.28346619493545}}]], 
    LineBox[NCache[{{3, 0}, {3, 19 + 52 Sin[3]}}, {{3, 0}, {
       3, 26.338240419113095`}}]], 
    LineBox[NCache[{{4, 0}, {4, 26 + 52 Sin[4]}}, {{4, 0}, {
       4, -13.353729756012264`}}]], 
    LineBox[NCache[{{5, 0}, {5, 35 + 52 Sin[5]}}, {{5, 0}, {
       5, -14.864062282483196`}}]], 
    LineBox[NCache[{{6, 0}, {6, 46 + 52 Sin[6]}}, {{6, 0}, {
       6, 31.470394093655855`}}]], 
    LineBox[NCache[{{7, 0}, {7, 59 + 52 Sin[7]}}, {{7, 0}, {
       7, 93.16330313337703}}]], 
    LineBox[NCache[{{8, 0}, {8, 74 + 52 Sin[8]}}, {{8, 0}, {
       8, 125.44662882441585`}}]], 
    LineBox[NCache[{{9, 0}, {9, 91 + 52 Sin[9]}}, {{9, 0}, {
       9, 112.43016123257135`}}]], 
    LineBox[NCache[{{10, 0}, {10, 110 + 52 Sin[10]}}, {{10, 0}, {
       10, 81.71090223375278}}]], 
    LineBox[NCache[{{11, 0}, {11, 131 + 52 Sin[11]}}, {{11, 0}, {
       11, 79.00050925936341}}]], 
    LineBox[NCache[{{12, 0}, {12, 154 + 52 Sin[12]}}, {{12, 0}, {
       12, 126.09820826397738`}}]], 
    LineBox[NCache[{{13, 0}, {13, 179 + 52 Sin[13]}}, {{13, 0}, {
       13, 200.84868591498534`}}]], 
    LineBox[NCache[{{14, 0}, {14, 206 + 52 Sin[14]}}, {{14, 0}, {
       14, 257.51158249613326`}}]], 
    LineBox[NCache[{{15, 0}, {15, 235 + 52 Sin[15]}}, {{15, 0}, {
       15, 268.8149676881701}}]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{2., 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->None]], "Output",
 CellChangeTimes->{
  3.42636120862932*^9, {3.426361257429491*^9, 3.426361277328104*^9}, 
   3.426361313770506*^9, 3.4263613491113234`*^9, 3.4263613959386578`*^9, {
   3.426361450597253*^9, 3.426361485817898*^9}}],

Cell[BoxData["\<\"trapezrule.eps\"\>"], "Output",
 CellChangeTimes->{
  3.42636120862932*^9, {3.426361257429491*^9, 3.426361277328104*^9}, 
   3.426361313770506*^9, 3.4263613491113234`*^9, 3.4263613959386578`*^9, {
   3.426361450597253*^9, 3.4263614858879986`*^9}}]
}, Open  ]]
},
WindowSize->{797, 851},
WindowMargins->{{24, Automatic}, {Automatic, 30}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 602, 17, 261, "Input"],
Cell[CellGroupData[{
Cell[1195, 42, 5281, 134, 775, "Input"],
Cell[6479, 178, 18897, 322, 310, "Output"],
Cell[25379, 502, 265, 4, 48, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
