(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15899,        437]
NotebookOptionsPosition[     15493,        421]
NotebookOutlinePosition[     15946,        438]
CellTagsIndexPosition[     15903,        435]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates slope fields and ODEs

Figures 9.1 was created with this notebook.

The slope field is a special case of a vectorfield, and as such it is created \
using the vectorfield function in Mathematica. The vector field function \
takes (f_x, f_y), so for our plot to show f_y over the domain t, we set f_x \
to a constant.

The latter part of the notebook demonstrates that some slope fields can \
generate very different solutions when the start point is change very \
slightly.

See Chapter 9 : Computing Dynamic Processes for details.

Updated July 2008\
\>", "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.426279747225792*^9, 3.4262798268502865`*^9}, {
   3.426281573982539*^9, 3.426281636963101*^9}, 3.4262818399750175`*^9, {
   3.426283147845643*^9, 3.4262832594461164`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Load", " ", "the", " ", "vector", " ", "filed", " ", "package"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Set", " ", "the", " ", "output", " ", "folder"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "a", " ", "slope", " ", "field"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vecfield", "=", 
     RowBox[{"VectorFieldPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "y"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "20"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Solve", " ", "an", " ", "ODE", " ", "for", " ", "given", " ", "start", 
      " ", "value", " ", "y", 
      RowBox[{"(", "0", ")"}]}], " ", "=", " ", "1"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"ssol1", "=", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
          RowBox[{"y", "[", "x", "]"}]}], ",", 
         RowBox[{
          RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1.0"}]}], "}"}], ",", 
       RowBox[{"y", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"ssol1", "=", 
     RowBox[{"ssol1", "\[LeftDoubleBracket]", 
      RowBox[{"1", ",", "1", ",", "2"}], "\[RightDoubleBracket]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Solve", " ", "the", " ", "same", " ", "ODE", " ", "with", " ", "a", " ",
       "different", " ", "start", " ", "value"}], ",", " ", 
     RowBox[{
      RowBox[{"y", 
       RowBox[{"(", "0", ")"}]}], " ", "=", " ", "0.2"}]}], " ", "*)"}], "\n",
    
   RowBox[{
    RowBox[{"ssol2", "=", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
          RowBox[{"y", "[", "x", "]"}]}], ",", 
         RowBox[{
          RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0.2"}]}], "}"}], ",", 
       RowBox[{"y", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"ssol2", "=", 
     RowBox[{"ssol2", "\[LeftDoubleBracket]", 
      RowBox[{"1", ",", "1", ",", "2"}], "\[RightDoubleBracket]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "plots", " ", "of", " ", "the", " ", "first", " ", "and", 
     " ", "second", " ", "ODE", " ", "solution"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"ssplot1", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{"ssol1", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "0.8`"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"0.3", ",", " ", "0.3", ",", " ", "0.8"}], "]"}], ",", 
          RowBox[{"Thickness", "[", "0.01`", "]"}]}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ssplot2", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{"ssol2", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"0.4", ",", " ", "0.4", ",", " ", "0.9"}], "]"}], ",", 
          RowBox[{"Thickness", "[", "0.01`", "]"}]}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "start", " ",
      "points", " ", "for", " ", "the", " ", "two", " ", "ODES", " ", 
     "above"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ppoints", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.2`"}], "}"}]}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"PointSize", "[", "0.03", "]"}]}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"ppoint", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1.`"}], "}"}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"PointSize", "[", "0.03", "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "the", " ", "plots"}], " ", "*)"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Top", " ", "left", " ", "of", " ", "FIgure", " ", "9.1"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"pic", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"{", "vecfield", "}"}], "]"}]}], "\n", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<vecfield.eps\>\"", ",", "pic"}], "]"}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"pic2", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{"vecfield", ",", "ssplot1", ",", "ppoint"}], "}"}], "]"}]}], 
   "\n", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<vecfield2.eps\>\"", ",", "pic2"}], "]"}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"pic3", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{"vecfield", ",", "ssplot1", ",", "ssplot2", ",", "ppoints"}], 
      "}"}], "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Output", " ", "this", " ", "to", " ", "a", " ", "postscript", " ", 
     "file"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<vecfield3.eps\>\"", ",", "pic3"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "different", " ", "slope", " ", "field"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vecfield1", "=", 
     RowBox[{"VectorFieldPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"y", "-", 
          RowBox[{"0.4`", " ", 
           SuperscriptBox["x", "2"]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "20"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Solve", " ", "this", " ", "ODE", " ", "with", " ", "a", " ", "given", 
     " ", "start", " ", "value"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"newsol1", "=", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"y", "[", "x", "]"}], "-", 
           RowBox[{"0.4`", " ", 
            SuperscriptBox["x", "2"]}]}]}], ",", 
         RowBox[{
          RowBox[{"y", "[", 
           RowBox[{"-", "2"}], "]"}], "\[Equal]", "0.7`"}]}], "}"}], ",", 
       RowBox[{"y", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"newsol1", "=", 
     RowBox[{"newsol1", "\[LeftDoubleBracket]", 
      RowBox[{"1", ",", "1", ",", "2"}], "\[RightDoubleBracket]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Now", " ", "solve", " ", "it", " ", "with", " ", "a", " ", "different", 
     " ", "start", " ", "value"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"newsol2", "=", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"y", "[", "x", "]"}], "-", 
           RowBox[{"0.4`", " ", 
            SuperscriptBox["x", "2"]}]}]}], ",", 
         RowBox[{
          RowBox[{"y", "[", 
           RowBox[{"-", "2"}], "]"}], "\[Equal]", "0.76`"}]}], "}"}], ",", 
       RowBox[{"y", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"newsol2", "=", 
     RowBox[{"newsol2", "\[LeftDoubleBracket]", 
      RowBox[{"1", ",", "1", ",", "2"}], "\[RightDoubleBracket]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "plots", " ", "of", " ", "the", " ", "elements"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"newsplot1", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{"newsol1", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"0.3", ",", " ", "0.3", ",", " ", "0.8"}], "]"}], ",", 
          RowBox[{"Thickness", "[", "0.01`", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"newsplot2", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{"newsol2", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"0.4", ",", " ", "0.4", ",", " ", "0.9"}], "]"}], ",", 
          RowBox[{"Thickness", "[", "0.01`", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"points", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "0.7`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "0.76`"}], "}"}]}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"PointSize", "[", "0.03`", "]"}]}]}], "]"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"pic1", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{
      "vecfield1", ",", "newsplot1", ",", "newsplot2", ",", "points"}], "}"}],
      "]"}]}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Output", " ", "this", " ", "to", " ", "a", " ", "postscript", " ", 
     "file"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<vecfield1.eps\>\"", ",", "pic1"}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.426279830515557*^9, 3.4262799171000595`*^9}, 
   3.426280210461893*^9, {3.426280245922883*^9, 3.4262802948732705`*^9}, {
   3.426280350403118*^9, 3.4262803530769634`*^9}, {3.426280397440755*^9, 
   3.4262805989605265`*^9}, {3.426280888617032*^9, 3.4262810386127152`*^9}, {
   3.4262810990295906`*^9, 3.4262812276445293`*^9}, {3.4262812592199326`*^9, 
   3.4262812616634464`*^9}, {3.4262813511921825`*^9, 
   3.4262813600148687`*^9}, {3.426281415454587*^9, 3.426281437486267*^9}, {
   3.426281489400917*^9, 3.42628149694176*^9}, {3.4262815463427954`*^9, 
   3.4262815563872385`*^9}}]
},
ScreenStyleEnvironment->"Working",
WindowSize->{743, 914},
WindowMargins->{{67, Automatic}, {Automatic, 0}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 967, 26, 432, "Input"],
Cell[1538, 49, 13951, 370, 1843, "Input"]
}
]
*)

(* End of internal cache information *)
