(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19985,        543]
NotebookOptionsPosition[     19533,        526]
NotebookOutlinePosition[     19951,        542]
CellTagsIndexPosition[     19908,        539]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates 

Figures  14.3, 14.4, 14.5, and 14.7 were created with this notebook.

See Chapter 14 : Visualizing Scalar Values over 2D for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.4268852764806957`*^9, 3.4268852909815474`*^9}, {
  3.4268853237086067`*^9, 3.4268853811812477`*^9}, {3.426887041098091*^9, 
  3.4268870639409375`*^9}},
 FormatType->"TextForm"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "the", " ", "output", " ", "folder"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "variable", " ", "to", " ", "change", " ", "the",
      " ", "number", " ", "of", " ", "evaluations", " ", "in", " ", "the", 
     " ", "plots"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"num", "=", "35"}], ";"}], ")"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "function", 
     " ", "sin", 
     RowBox[{"(", "xy", ")"}], " ", 
     RowBox[{"over", " ", "[", 
      RowBox[{
       RowBox[{"-", "pi"}], ",", "pi"}], "]"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "We", " ", "are", " ", "creating", " ", "4", " ", "versions", " ", 
     RowBox[{"below", " ", "--"}], " ", "different", " ", "rendering", " ", 
     "techniques"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"pic1", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"x", " ", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "num"}], ",", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic", ",", "None"}], "}"}]}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.033`"}], ",", "0.03`", ",", "3.381`"}], "}"}]}], 
       ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"pic2", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"x", " ", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "num"}], ",", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic", ",", "None"}], "}"}]}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.033`"}], ",", "0.03`", ",", "3.381`"}], "}"}]}], 
       ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"pic3", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"x", " ", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "num"}], ",", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic", ",", "None"}], "}"}]}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.033`"}], ",", "0.03`", ",", "3.381`"}], "}"}]}], 
       ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"White", "&"}], ")"}]}]}], "]"}]}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"pic4", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"x", " ", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"FaceForm", "[", "]"}]}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "num"}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.033`"}], ",", "0.03`", ",", "3.381`"}], "}"}]}], 
       ",", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic", ",", "None"}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Put", " ", "the", " ", "plots", " ", "together"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"g", "=", 
      RowBox[{"GraphicsGrid", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"pic1", ",", "pic2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"pic3", ",", "pic4"}], "}"}]}], "}"}], "]"}]}], ")"}], " ", 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Display", " ", "the", " ", "four", " ", "plots"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", "g", "]"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "a", " ", "postcript", " ", "file"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Uncomment", " ", "this", " ", "when", " ", 
     RowBox[{"wanted", " ", "--"}], " ", "takes", " ", "a", " ", "long", " ", 
     "time", " ", "to", " ", 
     RowBox[{"execute", "!"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<meshes.eps\>\"", ",", "g"}], "]"}], ";"}], " ", "*)"}], 
   " ", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.426885385908045*^9, 3.426885614326494*^9}, {
   3.426885657458515*^9, 3.4268856645386963`*^9}, {3.4268859588719263`*^9, 
   3.426885981875003*^9}, {3.426886419123736*^9, 3.4268864535632577`*^9}, 
   3.4268864917882223`*^9}],

Cell["\<\

Now experiments with a plotting style that uses random points distributed \
over the function.\
\>", "Input",
 CellChangeTimes->{{3.426885666942152*^9, 3.4268856971956544`*^9}},
 FormatType->"TextForm"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Define", " ", "the", " ", "number", " ", "of", " ", "points", " ", "to", 
    " ", "create"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"numpts", "=", 
      RowBox[{"35", " ", "35"}]}], ";"}], ")"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Define", " ", "a", " ", "function", " ", "to", " ", "evaluate"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"myf", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Sin", "[", 
       RowBox[{"x", " ", "y"}], "]"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "xy", " ", "points", " ", "over", " ", 
     RowBox[{"the", " ", "[", 
      RowBox[{
       RowBox[{"-", "pi"}], ",", "pi"}], "]"}], " ", "domain", " ", "using", 
     " ", "the", " ", "random", " ", "number", " ", 
     RowBox[{"generator", "."}]}], " ", "*)"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"pntsx", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"2", " ", "\[Pi]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"RandomReal", "[", "]"}], "-", "0.5`"}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "1", ",", "numpts"}], "}"}]}], "]"}]}], ";"}], 
     ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"pntsy", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"2", " ", "\[Pi]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"RandomReal", "[", "]"}], "-", "0.5`"}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", "1", ",", "numpts"}], "}"}]}], "]"}]}], ";"}], 
     ")"}]}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Evaluate", " ", "function", " ", "at", " ", "the", " ", "xy", " ", 
     "values", " ", "created"}], " ", "*)"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pntsz", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"myf", "[", 
         RowBox[{
          RowBox[{
          "pntsx", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
          ",", 
          RowBox[{
          "pntsy", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}], 
         "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "numpts"}], "}"}]}], "]"}]}], ";"}], 
    ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Load", " ", "the", " ", "xyz", " ", "values", " ", "into", " ", "a", " ",
      "table", " ", "for", " ", "plotting"}], " ", "*)"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pts", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
          "pntsx", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
          ",", 
          RowBox[{
          "pntsy", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
          ",", 
          RowBox[{"myf", "[", 
           RowBox[{
            RowBox[{
            "pntsx", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
            ",", 
            RowBox[{
            "pntsy", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}],
            "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "numpts"}], "}"}]}], "]"}]}], ";"}], 
    ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "a", " ", "plot"}], " ", "*)"}], 
   RowBox[{"ListPointPlot3D", "[", 
    RowBox[{"pts", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"PointSize", "[", "0.01`", "]"}]}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}], 
   " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Now", " ", "create", " ", "a", " ", "plot"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"numgrid", "=", "35"}], ";"}], ")"}], " ", "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Redefine", " ", "the", " ", "function", " ", "above", " ", "but", " ", 
     "so", " ", "we", " ", "get", " ", "points", " ", "on", " ", "a", " ", 
     "regular", " ", "grid"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"myf2", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", "\[Pi]", " ", 
          RowBox[{"(", 
           RowBox[{
            FractionBox["x", "numgrid"], "-", "0.5`"}], ")"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", " ", "\[Pi]", " ", 
          RowBox[{"(", 
           RowBox[{
            FractionBox["y", "numgrid"], "-", "0.5`"}], ")"}]}], ")"}]}], 
       "]"}]}], ";"}], ")"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Total", " ", "number", " ", "of", " ", "points", " ", "we", " ", "will", 
     " ", "generate"}], " ", "*)"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"numtot", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"numgrid", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"numgrid", "+", "1"}], ")"}]}], "-", "1"}]}], ";"}], ")"}], 
   " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"xpts", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Mod", "[", 
         RowBox[{"k", ",", 
          RowBox[{"numgrid", "+", "1"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "0", ",", "numtot"}], "}"}]}], "]"}]}], ";"}], 
    ")"}], " ", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"ypts", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"IntegerPart", "[", 
         FractionBox["k", 
          RowBox[{"numgrid", "+", "1"}]], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "0", ",", "numtot"}], "}"}]}], "]"}]}], ";"}], 
    ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pntsplot", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"(", 
            RowBox[{
             FractionBox[
              RowBox[{
              "xpts", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
              "numgrid"], "-", "0.5`"}], ")"}]}], ",", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"(", 
            RowBox[{
             FractionBox[
              RowBox[{
              "ypts", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
              "numgrid"], "-", "0.5`"}], ")"}]}], ",", 
          RowBox[{"myf2", "[", 
           RowBox[{
            RowBox[{
            "xpts", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
            ",", 
            RowBox[{
            "ypts", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}], 
           "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "numtot"}], "}"}]}], "]"}]}], ";"}], 
    ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"splot", "=", 
     RowBox[{"ListPointPlot3D", "[", 
      RowBox[{"pntsplot", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"PointSize", "[", "0.01`", "]"}]}], ",", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic", ",", "None"}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Output", " ", "pointcloud", " ", "to", " ", "postscript", " ", "file"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<pointcloud.eps\>\"", ",", "splot"}], "]"}], ";"}], " ", 
    "*)"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"This", " ", "is", " ", "a", " ", "VERY", " ", "smooth", " ", 
     RowBox[{"plot", " ", "--"}], " ", "with", " ", "a", " ", "lot", " ", 
     "evaluations"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"picsmooth", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"x", " ", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "200"}], ",", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic", ",", "None"}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "postscript", " ", "file"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<mesh_smooth.eps\>\"", ",", "picsmooth"}], "]"}], ";"}], 
    " ", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.426885385908045*^9, 3.426885614326494*^9}, {
  3.426885657458515*^9, 3.4268856645386963`*^9}, {3.4268865188771744`*^9, 
  3.426886719715966*^9}, {3.4268867958354206`*^9, 3.4268868752996845`*^9}, {
  3.426886965649602*^9, 3.4268869787985086`*^9}}]
},
WindowSize->{750, 742},
WindowMargins->{{6, Automatic}, {Automatic, 27}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 551, 17, 249, "Input"],
Cell[1122, 40, 7668, 195, 1105, "Input"],
Cell[8793, 237, 213, 6, 88, "Input"],
Cell[9009, 245, 10520, 279, 1378, "Input"]
}
]
*)

(* End of internal cache information *)
