(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     46805,       1143]
NotebookOptionsPosition[     46057,       1118]
NotebookOutlinePosition[     46475,       1134]
CellTagsIndexPosition[     46432,       1131]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook illustrates the types of domains in volume visualization.

This notebook needs fixed up a bit. The conversion from Mathematic 5.2 to 6.0 \
required a lot of changes -- not all done.

Figures  15.1 was created with this notebook. 

See Chapter 15 : Volume Visualization for details.

Updated May 2008\
\>", "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.426989445759429*^9, 3.4269895111434464`*^9}, {
  3.427037971049848*^9, 3.427038014592459*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "the", " ", "output", " ", "folder"}], " ", "*)"}], 
  "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "create", " ", "data", " ", "for", " ", "the", " ", "cell", " ", 
     "structures"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lst", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "cells"}], 
    " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"pts", "=", 
     RowBox[{"ListPointPlot3D", "[", 
      RowBox[{"lst", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"PointSize", "[", "0.05`", "]"}], ",", " ", "Black"}], 
         "]"}]}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "data", " ", "for", " ", "vertices", " ", "of", " ", 
     "another", " ", "domain"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lstv", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5`", ",", "0.5`", ",", "0.5`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", "1.5`", ",", "0.5`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5`", ",", "1.5`", ",", "0.5`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", "0.5`", ",", "1.5`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5`", ",", "0.5`", ",", "1.5`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", "1.5`", ",", "1.5`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5`", ",", "1.5`", ",", "1.5`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "point", " ",
      "set", " ", "making", " ", "up", " ", "a", " ", "cube"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ptsv", "=", 
     RowBox[{"ListPointPlot3D", "[", 
      RowBox[{"lstv", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"PointSize", "[", "0.05`", "]"}], ",", 
          RowBox[{"GrayLevel", "[", "0", "]"}]}], "]"}]}], ",", " ", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "cube", " ", "centered", " ", "at", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"1", "/", "2"}]}], ")"}]}], " ", "*)"}], "\[IndentingNewLine]",
    
   RowBox[{
    RowBox[{"cubev", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"Opacity", "[", "0.0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", " ", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"0.5`", ",", "0.5`", ",", "0.5`"}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "data", " ", "for", " ", "an", " ", "example", " ", 
     "illustrating", " ", "scattered", " ", "data"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"scatter", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "scattered", 
     " ", "data"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"ptsscatt", "=", 
     RowBox[{"ListPointPlot3D", "[", 
      RowBox[{"scatter", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"PointSize", "[", "0.05`", "]"}], ",", " ", "Black"}], 
         "]"}]}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\n", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "lines", " ",
      "connecting", " ", "the", " ", "scattered", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lines", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", " ", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}],
       "]"}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "some", " ", "special", " ", "lines"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"l0", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"l1", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"l2", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], "}"}], 
         "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"l3", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"l4", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"l5", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], "}"}], 
         "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"l6", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"l7", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "a", " ", "network", " ", "of", " ", 
     RowBox[{"cubes", " ", "--"}], " ", "each", " ", "with", " ", "a", " ", 
     "different", " ", "color"}], " ", "*)"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cube000", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.77`", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cube100", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.69`", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cube010", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.7`", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cube110", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.75`", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"cube001", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.65`", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"cube101", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.6`", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"cube011", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.7`", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cube111", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.55`", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "another", " ", "network", " ", "of", " ", "cubes"}], " ", 
    "*)"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "same", " ", "as", " ", "cubes", " ", "above", " ", "but", " ", "in", " ",
      "wireframe"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bcube000", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"Opacity", "[", "0.0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{"bcube100", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"Opacity", "[", "0.0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{"bcube010", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"Opacity", "[", "0.0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{"bcube110", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"Opacity", "[", "0.0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{"bcube001", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"Opacity", "[", "0.0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{"bcube101", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"Opacity", "[", "0.0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{"bcube011", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"Opacity", "[", "0.0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{"bcube111", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"Opacity", "[", "0.0", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"-", " ", "Create"}]}]}], " ", "the", " ", "four", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"pictures", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
        "--"}], "--"}]}], "-"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Put", " ", "together", " ", "the", " ", "picture", " ", "elements", " ", 
     "from", " ", "above"}], " ", "*)"}], "\n", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Put", " ", "together", " ", 
     RowBox[{"cubes", "  ", "--"}], " ", "each", " ", "cube", " ", "is", " ", 
     "colored", " ", "one", " ", "color"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"pic1", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
     "cube000", ",", "cube100", ",", "cube010", ",", "cube110", ",", 
      "cube001", ",", "cube101", ",", "cube011", ",", "cube111", ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Put", " ", "together", " ", "the", " ", 
     RowBox[{"bcubes", " ", "--"}], " ", "a", " ", "wireframe", " ", 
     "structure"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "is", " ", "a", " ", "rectilinear", " ", "grid", " ", "with",
      " ", "values", " ", "at", " ", "the", " ", "vertices"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"pic2", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
     "bcube000", ",", "bcube100", ",", "bcube010", ",", "bcube110", ",", 
      "bcube001", ",", "bcube101", ",", "bcube011", ",", "bcube111", ",", 
      "pts", ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "display", " ", "a", " ", "cell", " ", "defined", " ", "from", " ", 
     "eight", " ", "voxels"}], " ", "*)"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"bottom", " ", "left", " ", "pic"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"pic3", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
     "bcube000", ",", "bcube100", ",", "bcube010", ",", "bcube110", ",", 
      "bcube001", ",", "bcube101", ",", "bcube011", ",", "bcube111", ",", 
      "ptsv", ",", "cubev", ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1.508`", ",", 
         RowBox[{"-", "3.33`"}], ",", "0.927`"}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Scattered", " ", "data", " ", "example"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"pic4", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
     "ptsscatt", ",", "lines", ",", "l0", ",", "l1", ",", "l2", ",", "l3", 
      ",", "l4", ",", "l5", ",", "l6", ",", "l7", ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.888`"}], ",", 
         RowBox[{"-", "4.`"}], ",", "2.047`"}], "}"}]}]}], "]"}]}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "the", " ", "combined", " ", "picture"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g", "=", 
     RowBox[{"GraphicsGrid", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"pic1", ",", "pic2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"pic3", ",", "pic4"}], "}"}]}], "}"}], ",", 
       RowBox[{"Spacings", "\[Rule]", 
        RowBox[{"Scaled", "[", "0.25`", "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Display", " ", "it"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", "g", "]"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "a", " ", "postscript", " ", "file"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<voldata.eps\>\"", ",", "%"}], "]"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Here", " ", "is", " ", "a", " ", "subset", " ", "of", " ", "the", " ", 
     "examples", " ", "above"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g2", "=", 
     RowBox[{"GraphicsGrid", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"pic2", ",", "pic4"}], "}"}], "}"}], ",", 
       RowBox[{"Spacings", "\[Rule]", 
        RowBox[{"Scaled", "[", "0.25`", "]"}]}]}], "]"}]}], ";"}], "\n", 
   RowBox[{"Show", "[", "g2", "]"}], "\n", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<meshes3d.eps\>\"", ",", "%"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.426989515720027*^9, 3.4269895223395452`*^9}, {
   3.4269898921412945`*^9, 3.4269903794720416`*^9}, {3.426990416154789*^9, 
   3.4269906031236367`*^9}, {3.4269906830786066`*^9, 
   3.4269908026705713`*^9}, {3.426990852692499*^9, 3.426990926989333*^9}, {
   3.4269910089672112`*^9, 3.4269910537315793`*^9}, {3.4269911079895983`*^9, 
   3.42699111138448*^9}, {3.4269911485278893`*^9, 3.426991167425062*^9}, {
   3.4269912499537325`*^9, 3.426991389684656*^9}, {3.426991533821915*^9, 
   3.426991564836512*^9}, {3.4270354595284576`*^9, 3.42703546800064*^9}, {
   3.427035498033826*^9, 3.4270355256935987`*^9}, {3.427035590026104*^9, 
   3.4270356491210785`*^9}, {3.4270358252042737`*^9, 
   3.4270359270006495`*^9}, {3.427036348466688*^9, 3.427036360854501*^9}, {
   3.4270364165045214`*^9, 3.4270364791846514`*^9}, {3.4270365267430367`*^9, 
   3.427036530037774*^9}, {3.4270365758236113`*^9, 3.4270365795189247`*^9}, {
   3.4270366213490734`*^9, 3.427036643921531*^9}, {3.4270366865127745`*^9, 
   3.4270366886157985`*^9}, {3.4270367808784657`*^9, 3.4270367937569838`*^9}, 
   3.427036831260912*^9, {3.427036931374869*^9, 3.4270369767901726`*^9}, {
   3.4270370122311344`*^9, 3.4270370821016035`*^9}, {3.4270371155496993`*^9, 
   3.427037127316619*^9}, {3.4270371735931616`*^9, 3.427037212408976*^9}, {
   3.427037456229573*^9, 3.4270374639306464`*^9}, {3.4270375908431377`*^9, 
   3.427037736913176*^9}, {3.4270377748276944`*^9, 3.4270377846418066`*^9}, {
   3.4270378410328927`*^9, 3.427037895371027*^9}, {3.427037947135461*^9, 
   3.4270379504101696`*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0.77], CuboidBox[{0, 0, 0}]}, 
   {GrayLevel[0.69], CuboidBox[{1, 0, 0}]}, 
   {GrayLevel[0.7], CuboidBox[{0, 1, 0}]}, 
   {GrayLevel[0.75], CuboidBox[{1, 1, 0}]}, 
   {GrayLevel[0.65], CuboidBox[{0, 0, 1}]}, 
   {GrayLevel[0.6], CuboidBox[{1, 0, 1}]}, 
   {GrayLevel[0.7], CuboidBox[{0, 1, 1}]}, 
   {GrayLevel[0.55], CuboidBox[{1, 1, 1}]}},
  Boxed->False,
  ImageSize->{360., 390.7100357924894},
  ViewPoint->{1.4383115502227868`, -2.440288550788853, 1.8510136880597519`},
  ViewVertical->{0.043326771917807795`, -0.03674074704182566, 
   0.9983851503012205}]], "Output",
 CellChangeTimes->{
  3.4269902856871853`*^9, 3.4269908042828894`*^9, 3.4269909579037857`*^9, 
   3.4269911693277984`*^9, 3.4269913922883997`*^9, 3.4270355000266914`*^9, 
   3.4270358296606817`*^9, {3.4270358700788*^9, 3.427035896717104*^9}, 
   3.427036055315157*^9, 3.427036428261427*^9, 3.4270364843220387`*^9, 
   3.427036690658736*^9, 3.427036795359288*^9, 3.427036834135045*^9, {
   3.4270369332075043`*^9, 3.4270369628801713`*^9}, {3.427037016667514*^9, 
   3.427037049444645*^9}, 3.427037082722496*^9, 3.4270371937221055`*^9, 
   3.427037287987653*^9, 3.4270375386881423`*^9, {3.4270377137698975`*^9, 
   3.4270377376842847`*^9}, 3.4270377856432467`*^9, 3.4270378968231153`*^9, 
   3.4270379523629775`*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{0, 0, 0}]}, 
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{1, 0, 0}]}, 
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{0, 1, 0}]}, 
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{1, 1, 0}]}, 
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{0, 0, 1}]}, 
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{1, 0, 1}]}, 
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{0, 1, 1}]}, 
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{1, 1, 1}]}, 
   {GrayLevel[0], PointSize[0.05], 
    Point3DBox[{{0, 0, 0}, {1, 0, 0}, {2, 0, 0}, {0, 1, 0}, {1, 1, 0}, {2, 1, 
     0}, {0, 2, 0}, {1, 2, 0}, {2, 2, 0}, {0, 0, 1}, {1, 0, 1}, {2, 0, 1}, {0,
      1, 1}, {1, 1, 1}, {2, 1, 1}, {0, 2, 1}, {1, 2, 1}, {2, 2, 1}, {0, 0, 
     2}, {1, 0, 2}, {2, 0, 2}, {0, 1, 2}, {1, 1, 2}, {2, 1, 2}, {0, 2, 2}, {1,
      2, 2}, {2, 2, 2}}]}},
  Boxed->False,
  ImageSize->{360., 390.7100357924894},
  ViewPoint->{1.4383115502227868`, -2.440288550788853, 1.8510136880597519`},
  ViewVertical->{0.043326771917807795`, -0.03674074704182566, 
   0.9983851503012205}]], "Output",
 CellChangeTimes->{
  3.4269902856871853`*^9, 3.4269908042828894`*^9, 3.4269909579037857`*^9, 
   3.4269911693277984`*^9, 3.4269913922883997`*^9, 3.4270355000266914`*^9, 
   3.4270358296606817`*^9, {3.4270358700788*^9, 3.427035896717104*^9}, 
   3.427036055315157*^9, 3.427036428261427*^9, 3.4270364843220387`*^9, 
   3.427036690658736*^9, 3.427036795359288*^9, 3.427036834135045*^9, {
   3.4270369332075043`*^9, 3.4270369628801713`*^9}, {3.427037016667514*^9, 
   3.427037049444645*^9}, 3.427037082722496*^9, 3.4270371937221055`*^9, 
   3.427037287987653*^9, 3.4270375386881423`*^9, {3.4270377137698975`*^9, 
   3.4270377376842847`*^9}, 3.4270377856432467`*^9, 3.4270378968231153`*^9, 
   3.427037952533222*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{0, 0, 0}]}, 
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{1, 0, 0}]}, 
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{0, 1, 0}]}, 
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{1, 1, 0}]}, 
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{0, 0, 1}]}, 
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{1, 0, 1}]}, 
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{0, 1, 1}]}, 
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{1, 1, 1}]}, 
   {GrayLevel[0], PointSize[0.05], 
    Point3DBox[{{0.5, 0.5, 0.5}, {1.5, 0.5, 0.5}, {0.5, 1.5, 0.5}, {1.5, 1.5, 
     0.5}, {0.5, 0.5, 1.5}, {1.5, 0.5, 1.5}, {0.5, 1.5, 1.5}, {1.5, 1.5, 
     1.5}}]}, 
   {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
    CuboidBox[{0.5, 0.5, 0.5}]}},
  Boxed->False,
  ImageSize->{360., 390.7100357924894},
  ViewPoint->{1.508, -3.33, 0.927},
  ViewVertical->{0.043326771917807795`, -0.03674074704182566, 
   0.9983851503012205}]], "Output",
 CellChangeTimes->{
  3.4269902856871853`*^9, 3.4269908042828894`*^9, 3.4269909579037857`*^9, 
   3.4269911693277984`*^9, 3.4269913922883997`*^9, 3.4270355000266914`*^9, 
   3.4270358296606817`*^9, {3.4270358700788*^9, 3.427035896717104*^9}, 
   3.427036055315157*^9, 3.427036428261427*^9, 3.4270364843220387`*^9, 
   3.427036690658736*^9, 3.427036795359288*^9, 3.427036834135045*^9, {
   3.4270369332075043`*^9, 3.4270369628801713`*^9}, {3.427037016667514*^9, 
   3.427037049444645*^9}, 3.427037082722496*^9, 3.4270371937221055`*^9, 
   3.427037287987653*^9, 3.4270375386881423`*^9, {3.4270377137698975`*^9, 
   3.4270377376842847`*^9}, 3.4270377856432467`*^9, 3.4270378968231153`*^9, 
   3.4270379526133375`*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0], PointSize[0.05], 
    Point3DBox[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}, {0, -1, 0}, {-1, 0, 0}, {0, 
     0, -1}}]}, 
   {GrayLevel[0], EdgeForm[Thickness[Large]], 
    Line3DBox[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}, {0, -1, 0}, {-1, 0, 0}, {0, 
     0, -1}, {0, 0, 0}}]}, 
   {GrayLevel[0], EdgeForm[Thickness[Large]], 
    Line3DBox[{{0, 0, 1}, {1, 0, 0}}]}, 
   {GrayLevel[0], EdgeForm[Thickness[Large]], 
    Line3DBox[{{0, 0, 1}, {0, -1, 0}}]}, 
   {GrayLevel[0], EdgeForm[Thickness[Large]], 
    Line3DBox[{{0, 0, 1}, {-1, 0, 0}}]}, 
   {GrayLevel[0], EdgeForm[Thickness[Large]], 
    Line3DBox[{{0, 0, 0}, {0, 0, -1}}]}, 
   {GrayLevel[0], EdgeForm[Thickness[Large]], 
    Line3DBox[{{0, 0, 0}, {0, -1, 0}}]}, 
   {GrayLevel[0], EdgeForm[Thickness[Large]], 
    Line3DBox[{{0, 0, 0}, {-1, 0, 0}}]}, 
   {GrayLevel[0], EdgeForm[Thickness[Large]], 
    Line3DBox[{{0, 0, -1}, {1, 0, 0}}]}, 
   {GrayLevel[0], EdgeForm[Thickness[Large]], 
    Line3DBox[{{0, 0, -1}, {0, -1, 0}}]}},
  Axes->False,
  BoxRatios->{1, 1, 0.4},
  Boxed->False,
  ImageSize->{360., 390.7100357924894},
  PlotRange->{{-1, 1}, {-1, 0}, Automatic},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}},
  ViewPoint->{-0.888, -4., 2.047},
  ViewVertical->{0.043326771917807795`, -0.03674074704182566, 
   0.9983851503012205}]], "Output",
 CellChangeTimes->{
  3.4269902856871853`*^9, 3.4269908042828894`*^9, 3.4269909579037857`*^9, 
   3.4269911693277984`*^9, 3.4269913922883997`*^9, 3.4270355000266914`*^9, 
   3.4270358296606817`*^9, {3.4270358700788*^9, 3.427035896717104*^9}, 
   3.427036055315157*^9, 3.427036428261427*^9, 3.4270364843220387`*^9, 
   3.427036690658736*^9, 3.427036795359288*^9, 3.427036834135045*^9, {
   3.4270369332075043`*^9, 3.4270369628801713`*^9}, {3.427037016667514*^9, 
   3.427037049444645*^9}, 3.427037082722496*^9, 3.4270371937221055`*^9, 
   3.427037287987653*^9, 3.4270375386881423`*^9, {3.4270377137698975`*^9, 
   3.4270377376842847`*^9}, 3.4270377856432467`*^9, 3.4270378968231153`*^9, 
   3.427037952693453*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      Graphics3DBox[{
        {GrayLevel[0.77], CuboidBox[{0, 0, 0}]}, 
        {GrayLevel[0.69], CuboidBox[{1, 0, 0}]}, 
        {GrayLevel[0.7], CuboidBox[{0, 1, 0}]}, 
        {GrayLevel[0.75], CuboidBox[{1, 1, 0}]}, 
        {GrayLevel[0.65], CuboidBox[{0, 0, 1}]}, 
        {GrayLevel[0.6], CuboidBox[{1, 0, 1}]}, 
        {GrayLevel[0.7], CuboidBox[{0, 1, 1}]}, 
        {GrayLevel[0.55], CuboidBox[{1, 1, 1}]}},
       Boxed->False], {210., -210.}, ImageScaled[{0.5, 0.5}], {360., 360.},
      ContentSelectable->True], InsetBox[
      Graphics3DBox[{
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{0, 0, 0}]}, 
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{1, 0, 0}]}, 
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{0, 1, 0}]}, 
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{1, 1, 0}]}, 
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{0, 0, 1}]}, 
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{1, 0, 1}]}, 
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{0, 1, 1}]}, 
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{1, 1, 1}]}, 
        {GrayLevel[0], PointSize[0.05], 
         Point3DBox[{{0, 0, 0}, {1, 0, 0}, {2, 0, 0}, {0, 1, 0}, {1, 1, 0}, {
          2, 1, 0}, {0, 2, 0}, {1, 2, 0}, {2, 2, 0}, {0, 0, 1}, {1, 0, 1}, {2,
           0, 1}, {0, 1, 1}, {1, 1, 1}, {2, 1, 1}, {0, 2, 1}, {1, 2, 1}, {2, 
          2, 1}, {0, 0, 2}, {1, 0, 2}, {2, 0, 2}, {0, 1, 2}, {1, 1, 2}, {2, 1,
           2}, {0, 2, 2}, {1, 2, 2}, {2, 2, 2}}]}},
       Boxed->False], {630., -210.}, ImageScaled[{0.5, 0.5}], {360., 360.},
      ContentSelectable->True]}, {InsetBox[
      Graphics3DBox[{
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{0, 0, 0}]}, 
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{1, 0, 0}]}, 
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{0, 1, 0}]}, 
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{1, 1, 0}]}, 
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{0, 0, 1}]}, 
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{1, 0, 1}]}, 
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{0, 1, 1}]}, 
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{1, 1, 1}]}, 
        {GrayLevel[0], PointSize[0.05], 
         Point3DBox[{{0.5, 0.5, 0.5}, {1.5, 0.5, 0.5}, {0.5, 1.5, 0.5}, {1.5, 
          1.5, 0.5}, {0.5, 0.5, 1.5}, {1.5, 0.5, 1.5}, {0.5, 1.5, 1.5}, {1.5, 
          1.5, 1.5}}]}, 
        {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
         CuboidBox[{0.5, 0.5, 0.5}]}},
       Boxed->False,
       ViewPoint->{1.508, -3.33, 0.927}], {210., -630.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.},
      ContentSelectable->True], InsetBox[
      Graphics3DBox[{
        {GrayLevel[0], PointSize[0.05], 
         Point3DBox[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}, {0, -1, 0}, {-1, 0, 
          0}, {0, 0, -1}}]}, 
        {GrayLevel[0], EdgeForm[Thickness[Large]], 
         Line3DBox[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}, {0, -1, 0}, {-1, 0, 0}, {
          0, 0, -1}, {0, 0, 0}}]}, 
        {GrayLevel[0], EdgeForm[Thickness[Large]], 
         Line3DBox[{{0, 0, 1}, {1, 0, 0}}]}, 
        {GrayLevel[0], EdgeForm[Thickness[Large]], 
         Line3DBox[{{0, 0, 1}, {0, -1, 0}}]}, 
        {GrayLevel[0], EdgeForm[Thickness[Large]], 
         Line3DBox[{{0, 0, 1}, {-1, 0, 0}}]}, 
        {GrayLevel[0], EdgeForm[Thickness[Large]], 
         Line3DBox[{{0, 0, 0}, {0, 0, -1}}]}, 
        {GrayLevel[0], EdgeForm[Thickness[Large]], 
         Line3DBox[{{0, 0, 0}, {0, -1, 0}}]}, 
        {GrayLevel[0], EdgeForm[Thickness[Large]], 
         Line3DBox[{{0, 0, 0}, {-1, 0, 0}}]}, 
        {GrayLevel[0], EdgeForm[Thickness[Large]], 
         Line3DBox[{{0, 0, -1}, {1, 0, 0}}]}, 
        {GrayLevel[0], EdgeForm[Thickness[Large]], 
         Line3DBox[{{0, 0, -1}, {0, -1, 0}}]}},
       Axes->False,
       BoxRatios->{1, 1, 0.4},
       Boxed->False,
       PlotRange->{{-1, 1}, {-1, 0}, Automatic},
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.02], 
          Scaled[0.02]}, {Automatic, Automatic}},
       ViewPoint->{-0.888, -4., 2.047}], {630., -630.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.},
      ContentSelectable->True]}}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.4269902856871853`*^9, 3.4269908042828894`*^9, 3.4269909579037857`*^9, 
   3.4269911693277984`*^9, 3.4269913922883997`*^9, 3.4270355000266914`*^9, 
   3.4270358296606817`*^9, {3.4270358700788*^9, 3.427035896717104*^9}, 
   3.427036055315157*^9, 3.427036428261427*^9, 3.4270364843220387`*^9, 
   3.427036690658736*^9, 3.427036795359288*^9, 3.427036834135045*^9, {
   3.4270369332075043`*^9, 3.4270369628801713`*^9}, {3.427037016667514*^9, 
   3.427037049444645*^9}, 3.427037082722496*^9, 3.4270371937221055`*^9, 
   3.427037287987653*^9, 3.4270375386881423`*^9, {3.4270377137698975`*^9, 
   3.4270377376842847`*^9}, 3.4270377856432467`*^9, 3.4270378968231153`*^9, 
   3.4270379528336544`*^9}],

Cell[BoxData["\<\"voldata.eps\"\>"], "Output",
 CellChangeTimes->{
  3.4269902856871853`*^9, 3.4269908042828894`*^9, 3.4269909579037857`*^9, 
   3.4269911693277984`*^9, 3.4269913922883997`*^9, 3.4270355000266914`*^9, 
   3.4270358296606817`*^9, {3.4270358700788*^9, 3.427035896717104*^9}, 
   3.427036055315157*^9, 3.427036428261427*^9, 3.4270364843220387`*^9, 
   3.427036690658736*^9, 3.427036795359288*^9, 3.427036834135045*^9, {
   3.4270369332075043`*^9, 3.4270369628801713`*^9}, {3.427037016667514*^9, 
   3.427037049444645*^9}, 3.427037082722496*^9, 3.4270371937221055`*^9, 
   3.427037287987653*^9, 3.4270375386881423`*^9, {3.4270377137698975`*^9, 
   3.4270377376842847`*^9}, 3.4270377856432467`*^9, 3.4270378968231153`*^9, 
   3.427037953274288*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     Graphics3DBox[{
       {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
        CuboidBox[{0, 0, 0}]}, 
       {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
        CuboidBox[{1, 0, 0}]}, 
       {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
        CuboidBox[{0, 1, 0}]}, 
       {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
        CuboidBox[{1, 1, 0}]}, 
       {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
        CuboidBox[{0, 0, 1}]}, 
       {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
        CuboidBox[{1, 0, 1}]}, 
       {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
        CuboidBox[{0, 1, 1}]}, 
       {GrayLevel[0], Opacity[0.], EdgeForm[Thickness[Large]], 
        CuboidBox[{1, 1, 1}]}, 
       {GrayLevel[0], PointSize[0.05], 
        Point3DBox[{{0, 0, 0}, {1, 0, 0}, {2, 0, 0}, {0, 1, 0}, {1, 1, 0}, {2,
          1, 0}, {0, 2, 0}, {1, 2, 0}, {2, 2, 0}, {0, 0, 1}, {1, 0, 1}, {2, 0,
          1}, {0, 1, 1}, {1, 1, 1}, {2, 1, 1}, {0, 2, 1}, {1, 2, 1}, {2, 2, 
         1}, {0, 0, 2}, {1, 0, 2}, {2, 0, 2}, {0, 1, 2}, {1, 1, 2}, {2, 1, 
         2}, {0, 2, 2}, {1, 2, 2}, {2, 2, 2}}]}},
      Boxed->False], {210., -202.5}, ImageScaled[{0.5, 0.5}], {360., 360.},
     ContentSelectable->True], InsetBox[
     Graphics3DBox[{
       {GrayLevel[0], PointSize[0.05], 
        Point3DBox[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}, {0, -1, 0}, {-1, 0, 0}, {
         0, 0, -1}}]}, 
       {GrayLevel[0], EdgeForm[Thickness[Large]], 
        Line3DBox[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}, {0, -1, 0}, {-1, 0, 0}, {
         0, 0, -1}, {0, 0, 0}}]}, 
       {GrayLevel[0], EdgeForm[Thickness[Large]], 
        Line3DBox[{{0, 0, 1}, {1, 0, 0}}]}, 
       {GrayLevel[0], EdgeForm[Thickness[Large]], 
        Line3DBox[{{0, 0, 1}, {0, -1, 0}}]}, 
       {GrayLevel[0], EdgeForm[Thickness[Large]], 
        Line3DBox[{{0, 0, 1}, {-1, 0, 0}}]}, 
       {GrayLevel[0], EdgeForm[Thickness[Large]], 
        Line3DBox[{{0, 0, 0}, {0, 0, -1}}]}, 
       {GrayLevel[0], EdgeForm[Thickness[Large]], 
        Line3DBox[{{0, 0, 0}, {0, -1, 0}}]}, 
       {GrayLevel[0], EdgeForm[Thickness[Large]], 
        Line3DBox[{{0, 0, 0}, {-1, 0, 0}}]}, 
       {GrayLevel[0], EdgeForm[Thickness[Large]], 
        Line3DBox[{{0, 0, -1}, {1, 0, 0}}]}, 
       {GrayLevel[0], EdgeForm[Thickness[Large]], 
        Line3DBox[{{0, 0, -1}, {0, -1, 0}}]}},
      Axes->False,
      BoxRatios->{1, 1, 0.4},
      Boxed->False,
      PlotRange->{{-1, 1}, {-1, 0}, Automatic},
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}, {Automatic, Automatic}},
      ViewPoint->{-0.888, -4., 2.047}], {630., -202.5}, 
     ImageScaled[{0.5, 0.5}], {360., 360.},
     ContentSelectable->True]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.4269902856871853`*^9, 3.4269908042828894`*^9, 3.4269909579037857`*^9, 
   3.4269911693277984`*^9, 3.4269913922883997`*^9, 3.4270355000266914`*^9, 
   3.4270358296606817`*^9, {3.4270358700788*^9, 3.427035896717104*^9}, 
   3.427036055315157*^9, 3.427036428261427*^9, 3.4270364843220387`*^9, 
   3.427036690658736*^9, 3.427036795359288*^9, 3.427036834135045*^9, {
   3.4270369332075043`*^9, 3.4270369628801713`*^9}, {3.427037016667514*^9, 
   3.427037049444645*^9}, 3.427037082722496*^9, 3.4270371937221055`*^9, 
   3.427037287987653*^9, 3.4270375386881423`*^9, {3.4270377137698975`*^9, 
   3.4270377376842847`*^9}, 3.4270377856432467`*^9, 3.4270378968231153`*^9, 
   3.4270379533544035`*^9}],

Cell[BoxData["\<\"meshes3d.eps\"\>"], "Output",
 CellChangeTimes->{
  3.4269902856871853`*^9, 3.4269908042828894`*^9, 3.4269909579037857`*^9, 
   3.4269911693277984`*^9, 3.4269913922883997`*^9, 3.4270355000266914`*^9, 
   3.4270358296606817`*^9, {3.4270358700788*^9, 3.427035896717104*^9}, 
   3.427036055315157*^9, 3.427036428261427*^9, 3.4270364843220387`*^9, 
   3.427036690658736*^9, 3.427036795359288*^9, 3.427036834135045*^9, {
   3.4270369332075043`*^9, 3.4270369628801713`*^9}, {3.427037016667514*^9, 
   3.427037049444645*^9}, 3.427037082722496*^9, 3.4270371937221055`*^9, 
   3.427037287987653*^9, 3.4270375386881423`*^9, {3.4270377137698975`*^9, 
   3.4270377376842847`*^9}, 3.4270377856432467`*^9, 3.4270378968231153`*^9, 
   3.427037953624792*^9}]
}, Open  ]]
},
WindowSize->{753, 740},
WindowMargins->{{3, Automatic}, {Automatic, 20}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 627, 19, 322, "Input"],
Cell[CellGroupData[{
Cell[1220, 44, 26628, 697, 3635, "Input"],
Cell[27851, 743, 1334, 25, 519, "Output"],
Cell[29188, 770, 2056, 39, 519, "Output"],
Cell[31247, 811, 1938, 39, 519, "Output"],
Cell[33188, 852, 2143, 47, 519, "Output"],
Cell[35334, 901, 5539, 112, 481, "Output"],
Cell[40876, 1015, 759, 11, 48, "Output"],
Cell[41638, 1028, 3640, 74, 271, "Output"],
Cell[45281, 1104, 760, 11, 48, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
